/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.controller.game;

import com.jeremyzay.zaychess.controller.game.GameController;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.services.infrastructure.network.TcpClient;
import com.jeremyzay.zaychess.services.infrastructure.network.TcpHost;
import com.jeremyzay.zaychess.view.gui.ChessFrame;
import com.jeremyzay.zaychess.view.gui.MainMenuFrame;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class GameLauncher {
    public static void launch(GameState gameState, GameController controller) {
        new ChessFrame(gameState.getBoard(), controller);
    }

    public static void launchAsHost(GameState gameState, GameController controller, JDialog waitingDialog, MainMenuFrame menuFrame) {
        try {
            TcpHost host = new TcpHost(5000);
            controller.setLocalSide(PlayerColor.WHITE);
            controller.attachNetwork(host);
            if (waitingDialog != null) {
                waitingDialog.dispose();
            }
            SwingUtilities.invokeLater(() -> {
                new ChessFrame(gameState.getBoard(), controller);
                if (menuFrame != null) {
                    menuFrame.dispose();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean launchAsClient(GameState gameState, GameController controller, String ip) {
        try {
            TcpClient client = new TcpClient(ip, 5000);
            controller.setLocalSide(PlayerColor.BLACK);
            controller.attachNetwork(client);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        new ChessFrame(gameState.getBoard(), controller);
        return true;
    }
}

