/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.controller.saveload;

import com.jeremyzay.zaychess.controller.game.GameController;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.move.Move;
import com.jeremyzay.zaychess.model.move.MoveType;
import com.jeremyzay.zaychess.model.move.PromotionPiece;
import com.jeremyzay.zaychess.model.util.Position;
import com.jeremyzay.zaychess.services.application.notation.NotationSAN;
import com.jeremyzay.zaychess.services.infrastructure.network.MoveCodec;
import com.jeremyzay.zaychess.services.infrastructure.network.MoveMessage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;

public final class SaveManager {
    private final GameController controller;

    public SaveManager(GameController controller) {
        this.controller = controller;
    }

    public void saveGame(File file) throws IOException {
        List<String> lines = this.controller.getWireLog();
        Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public void loadGame(File file) throws IOException {
        GameState gs = this.controller.getGameState();
        gs.restoreFrom(new GameState());
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        for (String line : lines) {
            MoveType type;
            MoveMessage mm = MoveCodec.tryDecode(line);
            if (mm == null) continue;
            Position from = new Position(mm.fromRank(), mm.fromFile());
            Position to = new Position(mm.toRank(), mm.toFile());
            PromotionPiece promo = null;
            String t = mm.type();
            if (t != null && t.startsWith("PROMOTION")) {
                type = MoveType.PROMOTION;
                int i = t.indexOf(58);
                if (i > 0 && i + 1 < t.length()) {
                    promo = PromotionPiece.valueOf(t.substring(i + 1));
                }
            } else {
                type = MoveType.valueOf(t);
            }
            Move m = new Move(from, to, type, promo);
            GameState before = gs.copy();
            String san = NotationSAN.toSAN(before, m);
            gs.applyMove(m);
            this.controller.getWireLog().add(line);
            this.controller.dispatchMoveInfo(san);
        }
        if (this.controller.getBoardPanel() != null) {
            this.controller.getBoardPanel().updateBoard(gs.getBoard());
        }
    }
}

