/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.board;

import com.jeremyzay.zaychess.model.pieces.Piece;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public class Board {
    private final Piece[] squares1D = new Piece[64];

    public Piece getPieceAt(int rank, int file) {
        return this.squares1D[rank * 8 + file];
    }

    public Piece getPieceAt(Position pos) {
        return this.squares1D[pos.getRank() * 8 + pos.getFile()];
    }

    public void setPieceAt(int rank, int file, Piece piece) {
        this.squares1D[rank * 8 + file] = piece;
    }

    public void setPieceAt(Position pos, Piece piece) {
        this.squares1D[pos.getRank() * 8 + pos.getFile()] = piece;
    }

    public boolean isEmpty(Position pos) {
        return this.squares1D[pos.getRank() * 8 + pos.getFile()] == null;
    }

    public boolean isEmpty(int rank, int file) {
        return this.squares1D[rank * 8 + file] == null;
    }

    public Boolean isInside(int rank, int file) {
        try {
            new Position(rank, file);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public Board() {
    }

    public Board(Board other) {
        for (int i = 0; i < 64; ++i) {
            Piece p = other.squares1D[i];
            this.squares1D[i] = p == null ? null : p.copy();
        }
    }

    public List<Piece> getPiecesOfColor(PlayerColor color) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        for (int i = 0; i < 64; ++i) {
            if (this.squares1D[i] == null || this.squares1D[i].getColor() != color) continue;
            pieces.add(this.squares1D[i]);
        }
        return pieces;
    }

    public int rankOfIndex(int index) {
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException();
        }
        return index / 8;
    }

    public int fileOfIndex(int index) {
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException();
        }
        return index % 8;
    }
}

