/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.move;

import com.jeremyzay.zaychess.model.move.MoveType;
import com.jeremyzay.zaychess.model.move.PromotionPiece;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.Objects;

public final class Move {
    private final Position fromPos;
    private final Position toPos;
    private final MoveType moveType;
    private final PromotionPiece promotion;

    public Move(Position from, Position to, MoveType type) {
        this(from, to, type, null);
    }

    public Move(Position from, Position to, MoveType type, PromotionPiece promotion) {
        this.fromPos = Objects.requireNonNull(from);
        this.toPos = Objects.requireNonNull(to);
        this.moveType = Objects.requireNonNull(type);
        this.promotion = promotion;
    }

    public static Move promotion(Position from, Position to, PromotionPiece piece) {
        return new Move(from, to, MoveType.PROMOTION, Objects.requireNonNull(piece));
    }

    public static Move pendingPromotion(Position from, Position to) {
        return new Move(from, to, MoveType.PROMOTION, null);
    }

    public PromotionPiece getPromotion() {
        return this.promotion;
    }

    public Move withPromotion(PromotionPiece p) {
        return new Move(this.fromPos, this.toPos, this.moveType, Objects.requireNonNull(p));
    }

    public Position getFromPos() {
        return this.fromPos;
    }

    public Position getToPos() {
        return this.toPos;
    }

    public MoveType getMoveType() {
        return this.moveType;
    }

    public String toString() {
        return String.valueOf(this.getToPos()) + "," + String.valueOf((Object)this.getMoveType()) + ".";
    }
}

