/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.move;

import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.move.Move;
import com.jeremyzay.zaychess.model.move.MoveValidator;
import com.jeremyzay.zaychess.model.move.SpecialMoveHandler;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public abstract class MoveGenerator {
    public static List<Move> generateLegalMoves(GameState s, Position pos) {
        List<Move> pseudoLegalMoves = s.getPieceAt(pos).generatePseudoLegalMoves(s, pos);
        ArrayList<Move> legalMoves = new ArrayList<Move>();
        SpecialMoveHandler smHandler = s.getSpecialMoveHandler();
        smHandler.addEnPassantMoves(s, pos, pseudoLegalMoves);
        smHandler.addCastlingMoves(s, pos, pseudoLegalMoves);
        for (Move move : pseudoLegalMoves) {
            if (!MoveValidator.isValidMove(s, move)) continue;
            legalMoves.add(move);
        }
        return legalMoves;
    }

    public static List<Move> generateLegalMovesInTurn(GameState gameState, Position pos) {
        return null;
    }

    public static Move getValidMoveInTurn(GameState gameState, Position from, Position to) {
        if (!gameState.isTurn(gameState.getPieceColorAt(from))) {
            System.out.println(gameState.getTurn().toString() + " it's not your turn");
            return null;
        }
        for (Move legalMove : MoveGenerator.generateLegalMoves(gameState, from)) {
            if (!legalMove.getToPos().equals(to)) continue;
            return legalMove;
        }
        return null;
    }
}

