/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.pieces;

import com.jeremyzay.zaychess.model.board.Board;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.move.Move;
import com.jeremyzay.zaychess.model.move.MoveType;
import com.jeremyzay.zaychess.model.pieces.Piece;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public class King
extends Piece {
    public King(PlayerColor color, Position pos) {
        super(color, pos);
    }

    @Override
    public List<Move> generatePseudoLegalMoves(GameState gameState, Position from) {
        ArrayList<Move> moves = new ArrayList<Move>();
        Board board = gameState.getBoard();
        this.addMoves(board, moves, from.getRank(), from.getFile());
        return moves;
    }

    private Boolean addOneAdjMove(Board board, List<Move> moves, int r, int f, int dirR, int dirF) {
        int rank = r + dirR;
        int file = f + dirF;
        if (!board.isInside(rank, file).booleanValue()) {
            return false;
        }
        if (!board.isEmpty(rank, file) && !this.getColor().isOpposite(board.getPieceAt(rank, file).getColor())) {
            return false;
        }
        MoveType moveType = board.isEmpty(rank, file) ? MoveType.NORMAL : MoveType.CAPTURE;
        moves.add(new Move(new Position(r, f), new Position(rank, file), moveType));
        return board.isEmpty(rank, file);
    }

    private void addMoves(Board board, List<Move> moves, int r, int f) {
        for (int dr : new int[]{-1, 1}) {
            for (int df : new int[]{-1, 1}) {
                this.addOneAdjMove(board, moves, r, f, dr, df);
            }
        }
        for (int dr : new int[]{-1, 1}) {
            this.addOneAdjMove(board, moves, r, f, dr, 0);
        }
        for (int df : new int[]{-1, 1}) {
            this.addOneAdjMove(board, moves, r, f, 0, df);
        }
    }

    @Override
    public char getSymbol() {
        return 'K';
    }

    @Override
    public String getName() {
        return "king";
    }

    protected King(King other) {
        super(other);
    }

    @Override
    public Piece copy() {
        return new King(this);
    }

    public boolean isInCheck(GameState gameState) {
        List<Piece> enemyPieces = gameState.getPiecesOfColor(this.getColor().getOpposite());
        for (Piece piece : enemyPieces) {
            List<Move> pieceLegalMoves = piece.generatePseudoLegalMoves(gameState, piece.getPos());
            for (Move move : pieceLegalMoves) {
                if (!move.getToPos().equals(this.getPos())) continue;
                return true;
            }
        }
        return false;
    }
}

