/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.pieces;

import com.jeremyzay.zaychess.model.board.Board;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.move.Move;
import com.jeremyzay.zaychess.model.move.MoveType;
import com.jeremyzay.zaychess.model.pieces.Piece;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public class Pawn
extends Piece {
    public Pawn(PlayerColor color, Position pos) {
        super(color, pos);
    }

    private int dir() {
        return this.getColor() == PlayerColor.WHITE ? -1 : 1;
    }

    private int startRank() {
        return this.getColor() == PlayerColor.WHITE ? 6 : 1;
    }

    @Override
    public List<Move> generatePseudoLegalMoves(GameState gameState, Position from) {
        ArrayList<Move> moves = new ArrayList<Move>();
        int r = from.getRank();
        int f = from.getFile();
        int dir = this.dir();
        Board board = gameState.getBoard();
        this.addForwardMoves(board, moves, r, f, dir);
        this.addCaptureMoves(board, moves, r, f, dir);
        return moves;
    }

    private boolean isPromotionRank(int rank) {
        return this.getColor() == PlayerColor.WHITE ? rank == 0 : rank == 7;
    }

    private void addForwardMoves(Board board, List<Move> moves, int r, int f, int dir) {
        int oneStepRank = r + dir;
        if (!board.isInside(oneStepRank, f).booleanValue()) {
            return;
        }
        if (board.isEmpty(oneStepRank, f)) {
            Position from = new Position(r, f);
            Position to = new Position(oneStepRank, f);
            if (this.isPromotionRank(oneStepRank)) {
                moves.add(new Move(from, to, MoveType.PROMOTION));
            } else {
                int twoStepRank;
                moves.add(new Move(from, to, MoveType.NORMAL));
                if (r == this.startRank() && board.isInside(twoStepRank = r + 2 * dir, f).booleanValue() && board.isEmpty(twoStepRank, f)) {
                    moves.add(new Move(from, new Position(twoStepRank, f), MoveType.NORMAL));
                }
            }
        }
    }

    private void addCaptureMoves(Board board, List<Move> moves, int r, int f, int dir) {
        int[] nArray = new int[]{-1, 1};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int rank = r + dir;
            int df = nArray[i];
            int file = f + df;
            if (!board.isInside(rank, file).booleanValue() || board.isEmpty(rank, file) || !this.getColor().isOpposite(board.getPieceAt(rank, file).getColor())) continue;
            Position from = new Position(r, f);
            Position to = new Position(rank, file);
            if (this.isPromotionRank(rank)) {
                moves.add(new Move(from, to, MoveType.PROMOTION));
                continue;
            }
            moves.add(new Move(from, to, MoveType.CAPTURE));
        }
    }

    @Override
    public char getSymbol() {
        return 'p';
    }

    @Override
    public String getName() {
        return "pawn";
    }

    protected Pawn(Pawn other) {
        super(other);
    }

    @Override
    public Piece copy() {
        return new Pawn(this);
    }
}

