/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.pieces;

import com.jeremyzay.zaychess.model.board.Board;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.move.Move;
import com.jeremyzay.zaychess.model.move.MoveType;
import com.jeremyzay.zaychess.model.pieces.Piece;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public class Queen
extends Piece {
    public Queen(PlayerColor color, Position pos) {
        super(color, pos);
    }

    @Override
    public List<Move> generatePseudoLegalMoves(GameState gameState, Position from) {
        ArrayList<Move> moves = new ArrayList<Move>();
        Board board = gameState.getBoard();
        this.addMoves(board, moves, from.getRank(), from.getFile());
        return moves;
    }

    private Boolean addOneAdjMove(Board board, List<Move> moves, int orig_r, int orig_f, int r_i, int f_i, int dirR, int dirF) {
        int rank = r_i + dirR;
        int file = f_i + dirF;
        if (!board.isInside(rank, file).booleanValue()) {
            return false;
        }
        if (!board.isEmpty(rank, file) && !this.getColor().isOpposite(board.getPieceAt(rank, file).getColor())) {
            return false;
        }
        MoveType moveType = board.isEmpty(rank, file) ? MoveType.NORMAL : MoveType.CAPTURE;
        moves.add(new Move(new Position(orig_r, orig_f), new Position(rank, file), moveType));
        return board.isEmpty(rank, file);
    }

    private void addMoves(Board board, List<Move> moves, int r, int f) {
        for (int dr : new int[]{-1, 1}) {
            for (int df : new int[]{-1, 1}) {
                int r_i = r;
                int f_i = f;
                while (this.addOneAdjMove(board, moves, r, f, r_i, f_i, dr, df).booleanValue()) {
                    r_i += dr;
                    f_i += df;
                }
            }
        }
        for (int dr : new int[]{-1, 1}) {
            int r_i = r;
            while (this.addOneAdjMove(board, moves, r, f, r_i, f, dr, 0).booleanValue()) {
                r_i += dr;
            }
        }
        for (int df : new int[]{-1, 1}) {
            int f_i = f;
            while (this.addOneAdjMove(board, moves, r, f, r, f_i, 0, df).booleanValue()) {
                f_i += df;
            }
        }
    }

    @Override
    public char getSymbol() {
        return 'Q';
    }

    @Override
    public String getName() {
        return "queen";
    }

    protected Queen(Queen other) {
        super(other);
    }

    @Override
    public Piece copy() {
        return new Queen(this);
    }
}

