/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.model.util;

public final class Position {
    private final int rank;
    private final int file;

    public Position(int rank, int file) {
        if (rank < 0 || rank > 7 || file < 0 || file > 7) {
            throw new IllegalArgumentException("Coords out of range");
        }
        this.rank = rank;
        this.file = file;
    }

    public Position(Position other) {
        this.rank = other.rank;
        this.file = other.file;
    }

    public int getRank() {
        return this.rank;
    }

    public int getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.rank * 10 + this.file;
    }

    public String toString() {
        return "(" + this.getRank() + "," + this.getFile() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return this.rank == other.rank && this.file == other.file;
    }

    public Position copy() {
        return new Position(this);
    }
}

