/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.services.infrastructure.engine;

import com.jeremyzay.zaychess.services.infrastructure.engine.EngineService;
import com.jeremyzay.zaychess.services.infrastructure.engine.UciClient;

public final class SerendipityEngineService
implements EngineService {
    private final String javaCmd;
    private final String jarPath;
    private UciClient eng;

    public SerendipityEngineService(String javaCmd, String jarPath) {
        this.javaCmd = javaCmd;
        this.jarPath = jarPath;
    }

    @Override
    public void start() throws Exception {
        this.eng = UciClient.launchJar(this.javaCmd, this.jarPath);
        this.safeSet("Threads", String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.safeSet("Hash", "256");
        this.eng.newGame();
    }

    private void safeSet(String name, String value) {
        try {
            this.eng.setOption(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void newGame() throws Exception {
        this.eng.newGame();
    }

    @Override
    public void setOption(String name, String value) throws Exception {
        this.eng.setOption(name, value);
    }

    @Override
    public void setPositionFEN(String fen) throws Exception {
        if (fen == null || fen.isBlank()) {
            return;
        }
        this.eng.setPositionFEN(fen);
    }

    @Override
    public void pushUserMove(String uciMove) {
        this.eng.applyUserMove(uciMove);
    }

    @Override
    public String bestMoveMs(int movetimeMs) throws Exception {
        return this.eng.goMovetime(movetimeMs, 2000L).move();
    }

    @Override
    public void close() {
        if (this.eng != null) {
            this.eng.close();
        }
    }
}

