/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.services.infrastructure.network;

import com.jeremyzay.zaychess.services.infrastructure.network.NetworkTransport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpHost
implements NetworkTransport {
    private final int port;
    private volatile NetworkTransport.Listener listener;
    private ServerSocket server;
    private Socket client;
    private BufferedReader in;
    private PrintWriter out;
    private Thread acceptor;
    private Thread reader;

    public TcpHost(int port) {
        this.port = port;
    }

    @Override
    public void setListener(NetworkTransport.Listener l) {
        this.listener = l;
    }

    @Override
    public void start() {
        this.acceptor = new Thread(() -> {
            block2: {
                try {
                    this.server = new ServerSocket(this.port);
                    this.client = this.server.accept();
                    this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                    this.out = new PrintWriter(this.client.getOutputStream(), true);
                    this.out.println("HELLO");
                    this.reader = new Thread(() -> {
                        block3: {
                            try {
                                String line;
                                while ((line = this.in.readLine()) != null) {
                                    NetworkTransport.Listener L = this.listener;
                                    if (L == null) continue;
                                    L.onMessage(line);
                                }
                            }
                            catch (Exception e) {
                                NetworkTransport.Listener L = this.listener;
                                if (L == null) break block3;
                                L.onError(e);
                            }
                        }
                    }, "TcpHost-Reader");
                    this.reader.setDaemon(true);
                    this.reader.start();
                }
                catch (IOException e) {
                    NetworkTransport.Listener L = this.listener;
                    if (L == null) break block2;
                    L.onError(e);
                }
            }
        }, "TcpHost-Acceptor");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
    }

    @Override
    public void send(String line) {
        if (this.out != null) {
            this.out.println(line);
        }
    }

    @Override
    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.reader != null) {
            this.reader.interrupt();
        }
        if (this.acceptor != null) {
            this.acceptor.interrupt();
        }
    }
}

