/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AspectRatioPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JComponent child;
    private final Color bg;

    public AspectRatioPanel(JComponent child) {
        this(child, new Color(200, 200, 200));
    }

    public AspectRatioPanel(JComponent child, Color background) {
        super(null);
        this.child = child;
        this.bg = background;
        this.setOpaque(true);
        this.add(child);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void doLayout() {
        int w = this.getWidth();
        int h = this.getHeight();
        int side = Math.min(w, h);
        int x = (w - side) / 2;
        int y = (h - side) / 2;
        this.child.setBounds(x, y, side, side);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension c = this.child.getMinimumSize();
        int side = Math.min(c.width, c.height);
        return new Dimension(side, side);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension c = this.child.getPreferredSize();
        int side = Math.min(c.width, c.height);
        return new Dimension(side, side);
    }
}

