/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui;

import com.jeremyzay.zaychess.controller.game.GameController;
import com.jeremyzay.zaychess.controller.input.MouseInputHandler;
import com.jeremyzay.zaychess.controller.saveload.SaveManager;
import com.jeremyzay.zaychess.model.board.Board;
import com.jeremyzay.zaychess.view.gui.AspectRatioPanel;
import com.jeremyzay.zaychess.view.gui.BoardPanel;
import com.jeremyzay.zaychess.view.gui.MainMenuFrame;
import com.jeremyzay.zaychess.view.gui.MoveListPanel;
import com.jeremyzay.zaychess.view.gui.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ChessFrame
extends JFrame {
    private static final long serialVersionUID = 8987259664968168100L;
    private final BoardPanel boardPanel;
    private static final MoveListPanel moveListPanel = new MoveListPanel();
    private static final StatusPanel statusPanel = new StatusPanel();
    private boolean fullscreen = false;
    private Rectangle windowedBounds = null;
    private boolean windowedDecorations = true;
    private JSplitPane split;
    private boolean movesVisible = true;
    private int lastDivider = -1;
    private JToggleButton movesToggle;

    public ChessFrame(Board board, GameController controller) {
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        MouseInputHandler mouseInputHandler = new MouseInputHandler(controller);
        this.boardPanel = new BoardPanel(board, mouseInputHandler);
        controller.setBoardPanel(this.boardPanel);
        JPanel topBar = new JPanel(new FlowLayout(1, 8, 6));
        this.movesToggle = new JToggleButton("\u2261", true);
        this.movesToggle.setFocusable(false);
        this.movesToggle.setToolTipText("Toggle move panel");
        this.movesToggle.addActionListener(e -> this.toggleMovesPanel());
        topBar.add(this.movesToggle);
        if (!controller.isOnline() && !controller.isUsingEngine()) {
            JButton undoButton = new JButton("\u2190");
            undoButton.setMargin(new Insets(2, 6, 2, 6));
            undoButton.setFocusable(false);
            undoButton.setToolTipText("Undo move");
            undoButton.addActionListener(e -> {
                controller.undo();
                this.boardPanel.repaint();
            });
            topBar.add(undoButton);
            JButton redoButton = new JButton("\u2192");
            redoButton.setMargin(new Insets(2, 6, 2, 6));
            redoButton.setFocusable(false);
            redoButton.setToolTipText("Redo move");
            redoButton.addActionListener(e -> {
                controller.redo();
                this.boardPanel.repaint();
            });
            topBar.add(redoButton);
        }
        if (!controller.isOnline()) {
            JButton saveButton = new JButton("\ud83d\udcbe");
            saveButton.setMargin(new Insets(2, 6, 2, 6));
            saveButton.setFocusable(false);
            saveButton.setToolTipText("Save game");
            saveButton.addActionListener(e -> this.handleSave(controller));
            topBar.add(saveButton);
        }
        JButton exitButton = new JButton("\u274c");
        exitButton.setMargin(new Insets(2, 6, 2, 6));
        exitButton.setFocusable(false);
        exitButton.setToolTipText("Back to main menu");
        exitButton.addActionListener(e -> {
            this.dispose();
            SwingUtilities.invokeLater(() -> new MainMenuFrame().setVisible(true));
        });
        topBar.add(exitButton);
        this.add((Component)topBar, "North");
        AspectRatioPanel boardCenter = new AspectRatioPanel(this.boardPanel);
        this.split = new JSplitPane(1, boardCenter, moveListPanel);
        this.split.setBorder(null);
        this.split.setResizeWeight(1.0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(0.75);
        this.add((Component)this.split, "Center");
        this.add((Component)statusPanel, "South");
        this.setTitle("Zaychess");
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("F11"), "toggleFS");
        this.getRootPane().getActionMap().put("toggleFS", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ChessFrame.this.toggleFullscreen();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ctrl M"), "toggleMoves");
        this.getRootPane().getActionMap().put("toggleMoves", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChessFrame.this.toggleMovesPanel();
            }
        });
    }

    private void handleSave(GameController controller) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save game");
        chooser.setFileFilter(new FileNameExtensionFilter("Schachdatei (*.chesslog)", "chesslog"));
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            int confirm;
            File finalFile;
            File selected = chooser.getSelectedFile();
            Object path = selected.getAbsolutePath();
            if (!((String)path).toLowerCase().endsWith(".chesslog")) {
                path = (String)path + ".chesslog";
            }
            if ((finalFile = new File((String)path)).exists() && (confirm = JOptionPane.showConfirmDialog(this, "This game (" + finalFile.getName().split("\\.")[0] + ") already exists. Do you want to overwrite?", "Confirmation", 0)) != 0) {
                return;
            }
            try {
                new SaveManager(controller).saveGame(finalFile);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error saving: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void toggleFullscreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.fullscreen) {
            this.windowedBounds = this.getBounds();
            this.windowedDecorations = this.isUndecorated();
            try {
                this.dispose();
                this.setUndecorated(true);
                this.setVisible(true);
                if (gd.isFullScreenSupported()) {
                    gd.setFullScreenWindow(this);
                } else {
                    this.setExtendedState(6);
                }
                this.fullscreen = true;
            }
            catch (Exception ex) {
                this.setExtendedState(6);
                this.fullscreen = true;
            }
        } else {
            try {
                if (gd.getFullScreenWindow() == this) {
                    gd.setFullScreenWindow(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispose();
            this.setUndecorated(this.windowedDecorations);
            if (this.windowedBounds != null) {
                this.setBounds(this.windowedBounds);
            }
            this.setVisible(true);
            this.fullscreen = false;
        }
    }

    public BoardPanel getBoardPanel() {
        return this.boardPanel;
    }

    public static MoveListPanel getMoveListPanel() {
        return moveListPanel;
    }

    public static StatusPanel getStatusPanel() {
        return statusPanel;
    }

    public void updateBoard(Board board) {
        this.boardPanel.updateBoard(board);
    }

    private void toggleMovesPanel() {
        if (this.movesVisible) {
            this.lastDivider = this.split.getDividerLocation();
            this.split.setRightComponent(null);
            this.movesVisible = false;
        } else {
            this.split.setRightComponent(moveListPanel);
            this.split.resetToPreferredSizes();
            if (this.lastDivider > 0) {
                this.split.setDividerLocation(this.lastDivider);
            }
            this.movesVisible = true;
        }
        if (this.movesToggle != null) {
            this.movesToggle.setSelected(this.movesVisible);
        }
        this.revalidate();
        this.repaint();
    }
}

