/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui;

import com.jeremyzay.zaychess.controller.game.GameController;
import com.jeremyzay.zaychess.controller.game.GameLauncher;
import com.jeremyzay.zaychess.controller.saveload.SaveManager;
import com.jeremyzay.zaychess.model.game.GameState;
import com.jeremyzay.zaychess.model.util.PlayerColor;
import com.jeremyzay.zaychess.view.gui.ChessFrame;
import com.jeremyzay.zaychess.view.gui.MainMenuPanel;
import com.jeremyzay.zaychess.view.gui.MultiplayerMenuFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MainMenuFrame
extends JFrame {
    private static final long serialVersionUID = 4115239067261707835L;
    private final GameState gameState = new GameState();
    private final GameController controller;

    public MainMenuFrame() {
        try {
            this.controller = new GameController(this.gameState, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setTitle("Zaychess \u2013 Launcher");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        MainMenuPanel menuPanel = new MainMenuPanel(this, 500);
        this.add((Component)menuPanel, "Center");
        this.setContentPane(menuPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public void startLocalGame() {
        GameLauncher.launch(this.gameState, this.controller);
        ChessFrame.getMoveListPanel().clearMoves();
        this.dispose();
    }

    public void loadLocalGame() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Spiel laden");
        chooser.setFileFilter(new FileNameExtensionFilter("Schachdatei (*.chesslog)", "chesslog"));
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            try {
                GameLauncher.launch(this.gameState, this.controller);
                ChessFrame.getMoveListPanel().clearMoves();
                new SaveManager(this.controller).loadGame(chooser.getSelectedFile());
                this.dispose();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Fehler beim Laden: " + ex.getMessage(), "Ladefehler", 0);
            }
        }
    }

    public void startHostGame() {
        JDialog waitingDialog = this.openWaitingDialog();
        waitingDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MainMenuFrame.this.controller.getHost() != null) {
                    try {
                        MainMenuFrame.this.controller.getHost().close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(() -> MainMenuFrame.this.openMultiplayerMenu());
            }
        });
        SwingUtilities.invokeLater(() -> waitingDialog.setVisible(true));
        new Thread(() -> {
            GameLauncher.launchAsHost(this.gameState, this.controller, waitingDialog, this);
            ChessFrame.getMoveListPanel().clearMoves();
        }).start();
    }

    public void startClientGame(String ip) {
        JDialog loadingDialog = this.openLoadingDialog();
        SwingUtilities.invokeLater(() -> loadingDialog.setVisible(true));
        new Thread(() -> {
            boolean success = GameLauncher.launchAsClient(this.gameState, this.controller, ip);
            loadingDialog.dispose();
            if (success) {
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Unbekannter Host oder keine Verbindung m\u00f6glich.", "Verbindungsfehler", 0);
                this.openMultiplayerMenu();
            }
        }).start();
    }

    public void startVsComputer() {
        this.controller.setEngine();
        Object[] options = new Object[]{"\u2659", "\u265f", "\u274c"};
        int choice = JOptionPane.showOptionDialog(this, "Choose your side", "Play vs Computer", -1, 3, null, options, options[0]);
        if (choice == 2 || choice == -1) {
            return;
        }
        PlayerColor you = choice == 0 ? PlayerColor.WHITE : PlayerColor.BLACK;
        GameLauncher.launch(this.gameState, this.controller);
        this.controller.startEngineGame(you);
        ChessFrame.getMoveListPanel().clearMoves();
        this.dispose();
    }

    private JDialog openWaitingDialog() {
        JDialog dialog = new JDialog(this, "Warte auf Gegner...", false);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        dialog.add(progressBar);
        dialog.setSize(300, 75);
        dialog.setLocationRelativeTo(this);
        dialog.setDefaultCloseOperation(2);
        return dialog;
    }

    private JDialog openLoadingDialog() {
        JDialog dialog = new JDialog(this, "Verbinde...", true);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        dialog.add(progressBar);
        dialog.setSize(300, 75);
        dialog.setLocationRelativeTo(this);
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    public void openMultiplayerMenu() {
        new MultiplayerMenuFrame(this);
        this.setVisible(false);
    }
}

