/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui;

import com.jeremyzay.zaychess.view.gui.MainMenuFrame;
import com.jeremyzay.zaychess.view.gui.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MultiplayerMenuPanel
extends JPanel {
    private static final long serialVersionUID = -7348860546079045900L;
    private final Image backgroundImage = ResourceLoader.MAIN_MENU_BACKGROUND;

    public MultiplayerMenuPanel(JFrame frame, MainMenuFrame parent) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 0, 5, 0);
        Dimension buttonSize = new Dimension(180, 30);
        JButton hostButton = new JButton("Spiel hosten");
        JButton joinButton = new JButton("Spiel beitreten");
        JButton backButton = new JButton("Zur\u00fcck");
        hostButton.setPreferredSize(buttonSize);
        joinButton.setPreferredSize(buttonSize);
        backButton.setPreferredSize(buttonSize);
        hostButton.addActionListener(e -> {
            parent.startHostGame();
            frame.dispose();
        });
        joinButton.addActionListener(e -> {
            String ip = JOptionPane.showInputDialog(frame, "IP-Adresse des Hosts:", "Verbinden", 3);
            if (ip != null && !ip.trim().isEmpty()) {
                parent.startClientGame(ip.trim());
                frame.dispose();
            }
        });
        backButton.addActionListener(e -> {
            parent.setVisible(true);
            frame.dispose();
        });
        this.add((Component)hostButton, gbc);
        this.add((Component)joinButton, gbc);
        this.add((Component)backButton, gbc);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }
}

