/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui;

import com.jeremyzay.zaychess.model.pieces.Piece;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ResourceLoader {
    private static final String MAIN_MENU_BG_PATH = "/com/jeremyzay/zaychess/view/assets/main_menu_background.png";
    public static BufferedImage MAIN_MENU_BACKGROUND;
    private static final Map<String, ImageIcon> ICON_CACHE;
    private static final Map<String, ImageIcon> SCALED_ICON_CACHE;

    public static synchronized void preload() {
        if (MAIN_MENU_BACKGROUND != null) {
            return;
        }
        try (InputStream in = ResourceLoader.class.getResourceAsStream(MAIN_MENU_BG_PATH);){
            if (in == null) {
                throw new IllegalStateException("Resource not found: /com/jeremyzay/zaychess/view/assets/main_menu_background.png");
            }
            MAIN_MENU_BACKGROUND = ImageIO.read(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load /com/jeremyzay/zaychess/view/assets/main_menu_background.png", e);
        }
    }

    private static String piecePath(Piece p) {
        return "/com/jeremyzay/zaychess/view/assets/pieces/" + p.getColor().toString().toLowerCase() + "_" + p.getSymbol() + ".png";
    }

    private static ImageIcon loadIcon(String absoluteClasspathPath) {
        URL url = ResourceLoader.class.getResource(absoluteClasspathPath);
        if (url == null) {
            throw new IllegalStateException("Missing resource: " + absoluteClasspathPath);
        }
        return new ImageIcon(url);
    }

    public static ImageIcon getPieceIcon(Piece p) {
        String key = ResourceLoader.piecePath(p);
        return ICON_CACHE.computeIfAbsent(key, ResourceLoader::loadIcon);
    }

    public static ImageIcon getPieceIcon(Piece p, int size) {
        String baseKey = ResourceLoader.piecePath(p);
        String key = baseKey + "#" + size;
        return SCALED_ICON_CACHE.computeIfAbsent(key, k -> {
            ImageIcon base = ICON_CACHE.computeIfAbsent(baseKey, ResourceLoader::loadIcon);
            Image scaled = base.getImage().getScaledInstance(size, size, 4);
            return new ImageIcon(scaled);
        });
    }

    private ResourceLoader() {
    }

    static {
        ICON_CACHE = new ConcurrentHashMap<String, ImageIcon>();
        SCALED_ICON_CACHE = new ConcurrentHashMap<String, ImageIcon>();
    }
}

