/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyzay.zaychess.view.gui.swing;

import com.jeremyzay.zaychess.model.pieces.Piece;
import com.jeremyzay.zaychess.model.util.Position;
import com.jeremyzay.zaychess.view.gui.ResourceLoader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;

public class SquareButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final Position position;
    private final Color baseColor;
    private boolean highlighted;
    private Piece currentPiece;
    private final Color highlightColor = new Color(255, 0, 255);

    public SquareButton(Position position, Color baseColor) {
        this.position = position;
        this.baseColor = baseColor;
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SquareButton.this.updateScaledIcon();
            }
        });
    }

    public void setHighlighted(boolean h) {
        if (this.highlighted != h) {
            this.highlighted = h;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.baseColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.highlighted) {
            g2.setComposite(AlphaComposite.SrcOver.derive(0.35f));
            g2.setColor(this.highlightColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.dispose();
        super.paintComponent(g);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPiece(Piece piece) {
        this.currentPiece = piece;
        this.updateScaledIcon();
    }

    private void updateScaledIcon() {
        if (this.currentPiece == null) {
            this.setIcon(null);
            return;
        }
        int sz = Math.min(this.getWidth(), this.getHeight());
        if (sz <= 0) {
            sz = 70;
        }
        this.setIcon(ResourceLoader.getPieceIcon(this.currentPiece, sz));
        this.setDisabledIcon(this.getIcon());
    }
}

