/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess;

import org.shawn.games.Serendipity.Chess.Bitboard;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.Chess.Square;

public class Attacks {
    private static final long[] kingAttacks;
    private static final long[] knightAttacks;
    private static final long[] bishopMask;
    private static final int[] bishopShift;
    private static final long[] bishopMagic;
    private static final long[][] bishopAttacks;
    private static final long[] rookMask;
    private static final int[] rookShift;
    private static final long[] rookMagic;
    private static final long[][] rookAttacks;

    public static Square shift(Square square, Direction direction) {
        return Square.fromBitboard(Attacks.shift(square.getBitboard(), direction));
    }

    public static long shift(long bitboard, Direction direction) {
        switch (direction.ordinal()) {
            case 0: {
                return bitboard << 8;
            }
            case 1: {
                return bitboard >>> 8;
            }
            case 2: {
                return (bitboard & (Bitboard.fileBB[7] ^ 0xFFFFFFFFFFFFFFFFL)) << 1;
            }
            case 3: {
                return (bitboard & (Bitboard.fileBB[0] ^ 0xFFFFFFFFFFFFFFFFL)) >>> 1;
            }
            case 4: {
                return (bitboard & (Bitboard.fileBB[7] ^ 0xFFFFFFFFFFFFFFFFL)) << 9;
            }
            case 5: {
                return (bitboard & (Bitboard.fileBB[0] ^ 0xFFFFFFFFFFFFFFFFL)) << 7;
            }
            case 6: {
                return (bitboard & (Bitboard.fileBB[7] ^ 0xFFFFFFFFFFFFFFFFL)) >>> 7;
            }
            case 7: {
                return (bitboard & (Bitboard.fileBB[0] ^ 0xFFFFFFFFFFFFFFFFL)) >>> 9;
            }
        }
        return bitboard;
    }

    private static long generateKnightAttacks(Square square) {
        long attacks = 0L;
        long squareBB = square.getBitboard();
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.NORTH), Direction.NORTHEAST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.NORTH), Direction.NORTHWEST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.SOUTH), Direction.SOUTHEAST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.SOUTH), Direction.SOUTHWEST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.EAST), Direction.NORTHEAST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.EAST), Direction.SOUTHEAST);
        attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.WEST), Direction.NORTHWEST);
        return attacks |= Attacks.shift(Attacks.shift(squareBB, Direction.WEST), Direction.SOUTHWEST);
    }

    private static long generateKingAttacks(Square square) {
        long attacks = 0L;
        long squareBB = square.getBitboard();
        attacks |= Attacks.shift(squareBB, Direction.NORTH);
        attacks |= Attacks.shift(squareBB, Direction.SOUTH);
        attacks |= Attacks.shift(squareBB, Direction.EAST);
        attacks |= Attacks.shift(squareBB, Direction.WEST);
        attacks |= Attacks.shift(squareBB, Direction.NORTHEAST);
        attacks |= Attacks.shift(squareBB, Direction.NORTHWEST);
        attacks |= Attacks.shift(squareBB, Direction.SOUTHEAST);
        return attacks |= Attacks.shift(squareBB, Direction.SOUTHWEST);
    }

    private static long generateRayMask(Square square, Direction direction) {
        long mask = 0L;
        long sqBB = square.getBitboard();
        long nextBB = Attacks.shift(sqBB, direction);
        while (0L != (nextBB = Attacks.shift(sqBB = nextBB, direction))) {
            mask |= sqBB;
        }
        return mask;
    }

    private static long generateBishopMask(Square square) {
        long mask = 0L;
        mask |= Attacks.generateRayMask(square, Direction.NORTHEAST);
        mask |= Attacks.generateRayMask(square, Direction.NORTHWEST);
        mask |= Attacks.generateRayMask(square, Direction.SOUTHEAST);
        return mask |= Attacks.generateRayMask(square, Direction.SOUTHWEST);
    }

    private static long generateRookMask(Square square) {
        long mask = 0L;
        mask |= Attacks.generateRayMask(square, Direction.NORTH);
        mask |= Attacks.generateRayMask(square, Direction.SOUTH);
        mask |= Attacks.generateRayMask(square, Direction.EAST);
        return mask |= Attacks.generateRayMask(square, Direction.WEST);
    }

    private static int generateMagicShift(long mask) {
        return 64 - Long.bitCount(mask);
    }

    private static long generateRayAttack(Square square, Direction direction, long occ) {
        long attack = 0L;
        long sqBB = square.getBitboard();
        while ((sqBB = Attacks.shift(sqBB, direction)) != 0L && 0L == ((attack |= sqBB) & occ)) {
        }
        return attack;
    }

    private static long generateBishopAttack(Square square, long occ) {
        long attack = 0L;
        attack |= Attacks.generateRayAttack(square, Direction.NORTHEAST, occ);
        attack |= Attacks.generateRayAttack(square, Direction.NORTHWEST, occ);
        attack |= Attacks.generateRayAttack(square, Direction.SOUTHEAST, occ);
        return attack |= Attacks.generateRayAttack(square, Direction.SOUTHWEST, occ);
    }

    private static long generateRookAttack(Square square, long occ) {
        long attack = 0L;
        attack |= Attacks.generateRayAttack(square, Direction.NORTH, occ);
        attack |= Attacks.generateRayAttack(square, Direction.SOUTH, occ);
        attack |= Attacks.generateRayAttack(square, Direction.EAST, occ);
        return attack |= Attacks.generateRayAttack(square, Direction.WEST, occ);
    }

    private static long[] generateBishopAttacks(Square square, long mask, long magic, int shift) {
        long[] attacks = new long[512];
        long cur_mask = mask;
        while (true) {
            attacks[(int)(cur_mask * magic >>> shift)] = Attacks.generateBishopAttack(square, cur_mask);
            if (0L == cur_mask) break;
            cur_mask = cur_mask - 1L & mask;
        }
        return attacks;
    }

    private static long[] generateRookAttacks(Square square, long mask, long magic, int shift) {
        long[] attacks = new long[4096];
        long cur_mask = mask;
        while (true) {
            attacks[(int)(cur_mask * magic >>> shift)] = Attacks.generateRookAttack(square, cur_mask);
            if (0L == cur_mask) break;
            cur_mask = cur_mask - 1L & mask;
        }
        return attacks;
    }

    public static long getPawnAttacks(Side side, long pawnBB) {
        if (side.equals((Object)Side.WHITE)) {
            return Attacks.shift(pawnBB, Direction.NORTHEAST) | Attacks.shift(pawnBB, Direction.NORTHWEST);
        }
        return Attacks.shift(pawnBB, Direction.SOUTHEAST) | Attacks.shift(pawnBB, Direction.SOUTHWEST);
    }

    public static long getPawnCaptures(Side side, long pawnBB, long occupied, Square enPassant) {
        long pawnAttacks = Attacks.getPawnAttacks(side, pawnBB);
        if (!enPassant.equals((Object)Square.NONE)) {
            long ep = enPassant.getBitboard();
            occupied |= side.equals((Object)Side.WHITE) ? ep << 8 : ep >> 8;
        }
        return pawnAttacks & occupied;
    }

    public static long getPawnMoves(Side side, long pawnBB, long occupied) {
        Direction pushDirection = side.equals((Object)Side.WHITE) ? Direction.NORTH : Direction.SOUTH;
        long doublePushMask = side.equals((Object)Side.WHITE) ? Bitboard.rankBB[3] : Bitboard.rankBB[4];
        long pawnPushes = Attacks.shift(pawnBB, pushDirection) & (occupied ^ 0xFFFFFFFFFFFFFFFFL);
        long pawnDoublePushes = Attacks.shift(pawnPushes, pushDirection) & doublePushMask & (occupied ^ 0xFFFFFFFFFFFFFFFFL);
        return pawnPushes | pawnDoublePushes;
    }

    public static long getKnightAttacks(Square square, long mask) {
        return knightAttacks[square.ordinal()] & mask;
    }

    public static long getBishopAttacks(long mask, Square square) {
        long blockerMask = bishopMask[square.ordinal()];
        long magic = bishopMagic[square.ordinal()];
        int shift = bishopShift[square.ordinal()];
        return bishopAttacks[square.ordinal()][(int)((mask & blockerMask) * magic >>> shift)];
    }

    public static long getRookAttacks(long mask, Square square) {
        long blockerMask = rookMask[square.ordinal()];
        long magic = rookMagic[square.ordinal()];
        int shift = rookShift[square.ordinal()];
        return rookAttacks[square.ordinal()][(int)((mask & blockerMask) * magic >>> shift)];
    }

    public static long getQueenAttacks(long mask, Square square) {
        return Attacks.getRookAttacks(mask, square) | Attacks.getBishopAttacks(mask, square);
    }

    public static long getKingAttacks(Square square, long mask) {
        return kingAttacks[square.ordinal()] & mask;
    }

    static {
        knightAttacks = new long[64];
        kingAttacks = new long[64];
        bishopMask = new long[64];
        bishopShift = new int[64];
        bishopMagic = Precomputed.bishopMagic;
        bishopAttacks = new long[64][512];
        rookMask = new long[64];
        rookShift = new int[64];
        rookAttacks = new long[64][4096];
        rookMagic = Precomputed.rookMagic;
        for (int sqIdx = 0; sqIdx < 64; ++sqIdx) {
            Square sq = Square.values()[sqIdx];
            Attacks.knightAttacks[sqIdx] = Attacks.generateKnightAttacks(sq);
            Attacks.kingAttacks[sqIdx] = Attacks.generateKingAttacks(sq);
            Attacks.bishopMask[sqIdx] = Attacks.generateBishopMask(sq);
            Attacks.bishopShift[sqIdx] = Attacks.generateMagicShift(bishopMask[sqIdx]);
            Attacks.bishopAttacks[sqIdx] = Attacks.generateBishopAttacks(sq, bishopMask[sqIdx], bishopMagic[sqIdx], bishopShift[sqIdx]);
            Attacks.rookMask[sqIdx] = Attacks.generateRookMask(sq);
            Attacks.rookShift[sqIdx] = Attacks.generateMagicShift(rookMask[sqIdx]);
            Attacks.rookAttacks[sqIdx] = Attacks.generateRookAttacks(sq, rookMask[sqIdx], rookMagic[sqIdx], rookShift[sqIdx]);
        }
    }

    public static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        NORTHEAST,
        NORTHWEST,
        SOUTHEAST,
        SOUTHWEST;

    }

    private class Precomputed {
        private static final long[] bishopMagic = new long[]{578786288149594208L, 4576176320833794L, 1162269706682644L, 145815110361830032L, -9218303219527057408L, 576743705831014528L, 1145725543269632L, 360573849724782084L, 720690440180991489L, 4611971960203659521L, 7495203645110101092L, 5188149109374141440L, 11003983036424L, 180355675514225072L, -8935141368376061824L, 2598603960742973442L, 2308103623664732176L, 1134730376905224L, -4611094189107445248L, 42784198641075200L, -9219412953164151808L, 297307978662416417L, 23080952411460609L, 2306267421540945920L, 581188035037699L, 520262514019139844L, 289079199154308096L, 422354333335584L, 38562141082566656L, 4611828954955841664L, -8645784008442625536L, 1153486653793550669L, 9325028984226816L, 74313860886168064L, 3378008958243328L, 180214423766827520L, 72621110929260576L, 4621264972318523472L, 81628310198879234L, 5633903226331392L, 396881925851127808L, 151055322684002304L, 72411637872594976L, 9165666974173184L, 576531192233464322L, 45616547036790816L, 1234096266800038016L, 38421901265097928L, 1145725543269632L, 1315209973039374341L, -9223334204567190528L, 612490100185628672L, 2305847424712974400L, 292751705427738666L, 578786288149594208L, 4576176320833794L, 360573849724782084L, 2598603960742973442L, 6918414138867912706L, -9218129548030212095L, 74313860886168064L, 288230393872908544L, 720690440180991489L, 578786288149594208L};
        private static final long[] rookMagic = new long[]{36029072039546912L, 5206161444655206409L, 6413146761707143208L, -6593252260136548351L, 1801457477494308866L, -6629122695235370992L, 4683744712523382820L, 1188950443359755392L, 703722875420704L, 70506187329536L, 141287512612864L, 2315413433736040480L, 9288744158953988L, 281510477316864L, 144396680265990400L, 865113345215185024L, 8022586663371296L, 27163435318001665L, 9010498864423169L, 18155686022285312L, 33777548171411584L, 4612531543338927640L, 7205763801943113992L, 10995120734337L, 37225067817631778L, 1225067062796230657L, 2598577055861833856L, 281651071418532L, -9221111438800322432L, 288793878009741350L, 2264998264963584L, 7493990218031237252L, 4614008204710379658L, 2342329205225701384L, 288318616338702336L, 4621292735020666952L, 180566214781700097L, 703979524720128L, 144308708766122568L, 576461853459218580L, 37225067817631778L, 387029435236352L, 4612249793560444944L, 4612249793560444944L, 563396898848800L, 1190639186115952645L, 1477910766417084496L, 3558116268572673L, -9222738073905593856L, -9222738073905593856L, 2486063977572893184L, 4609737127690496L, -9221111438800322432L, 281510477316864L, 144396680265990400L, 4647715374933284352L, 9043484230057989L, -9220768392766549375L, 72235923230294210L, 1279585519140865074L, 4620974701316982785L, 77124212355507282L, 7494570396314896388L, -8059046397048975294L};

        private Precomputed() {
        }
    }
}

