/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess;

import java.util.LinkedList;
import java.util.List;
import org.shawn.games.Serendipity.Chess.File;
import org.shawn.games.Serendipity.Chess.Rank;
import org.shawn.games.Serendipity.Chess.Square;

public class Bitboard {
    public static final long lightSquares = 0x55AA55AA55AA55AAL;
    public static final long darkSquares = -6172840429334713771L;
    static final long[] rankBB = new long[]{255L, 65280L, 0xFF0000L, 0xFF000000L, 0xFF00000000L, 0xFF0000000000L, 0xFF000000000000L, -72057594037927936L};
    static final long[] fileBB = new long[]{0x101010101010101L, 0x202020202020202L, 0x404040404040404L, 0x808080808080808L, 0x1010101010101010L, 0x2020202020202020L, 0x4040404040404040L, -9187201950435737472L};
    static final long[][] bbTable = new long[64][64];

    static long sq2Bb(Square sq) {
        return sq.getBitboard();
    }

    public static int bitScanForward(long bb) {
        return Long.numberOfTrailingZeros(bb);
    }

    public static int bitScanReverse(long bb) {
        return 63 - Long.numberOfLeadingZeros(bb);
    }

    public static long bitsBetween(long bb, int sq1, int sq2) {
        return bbTable[sq1][sq2] & bb;
    }

    public static long extractLsb(Long bb) {
        return bb & bb - 1L;
    }

    public static boolean hasOnly1Bit(Long bb) {
        return bb != 0L && Bitboard.extractLsb(bb) == 0L;
    }

    public static long getBbtable(Square sq) {
        return 1L << sq.ordinal();
    }

    public static List<Square> bbToSquareList(long bb) {
        LinkedList<Square> squares = new LinkedList<Square>();
        while (bb != 0L) {
            int sq = Bitboard.bitScanForward(bb);
            bb = Bitboard.extractLsb(bb);
            squares.add(Square.squareAt(sq));
        }
        return squares;
    }

    public static Square[] bbToSquareArray(long bb) {
        Square[] squares = new Square[Long.bitCount(bb)];
        int index = 0;
        while (bb != 0L) {
            int sq = Bitboard.bitScanForward(bb);
            bb = Bitboard.extractLsb(bb);
            squares[index++] = Square.squareAt(sq);
        }
        return squares;
    }

    public static long[] getRankbb() {
        return rankBB;
    }

    public static long[] getFilebb() {
        return fileBB;
    }

    public static long getRankbb(Square sq) {
        return rankBB[sq.getRank().ordinal()];
    }

    public static long getFilebb(Square sq) {
        return fileBB[sq.getFile().ordinal()];
    }

    public static long getRankbb(Rank rank) {
        return rankBB[rank.ordinal()];
    }

    public static long getFilebb(File file) {
        return fileBB[file.ordinal()];
    }

    public static String bitboardToString(long bb) {
        StringBuilder b = new StringBuilder();
        for (int x = 0; x < 64; ++x) {
            if ((1L << x & bb) != 0L) {
                b.append("1");
            } else {
                b.append("0");
            }
            if ((x + 1) % 8 != 0) continue;
            b.append("\n");
        }
        return b.toString();
    }

    static {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                Bitboard.bbTable[x][y] = 1L << y | (1L << y) - (1L << x);
            }
        }
    }
}

