/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.shawn.games.Serendipity.Chess.AccumulatorDiff;
import org.shawn.games.Serendipity.Chess.Attacks;
import org.shawn.games.Serendipity.Chess.Bitboard;
import org.shawn.games.Serendipity.Chess.BoardContext;
import org.shawn.games.Serendipity.Chess.CastleRight;
import org.shawn.games.Serendipity.Chess.Constants;
import org.shawn.games.Serendipity.Chess.File;
import org.shawn.games.Serendipity.Chess.MoveBackup;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.PieceType;
import org.shawn.games.Serendipity.Chess.Rank;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Chess.move.MoveGenerator;
import org.shawn.games.Serendipity.Chess.move.MoveList;
import org.shawn.games.Serendipity.Chess.util.XorShiftRandom;

public class Board
implements Cloneable {
    private static final List<Long> keys = new ArrayList<Long>();
    private static final long RANDOM_SEED = 49109794719L;
    private static final int ZOBRIST_TABLE_SIZE = 2000;
    private final LinkedList<MoveBackup> backup;
    private final long[] bitboard;
    private final long[] bbSide;
    private final Piece[] occupation;
    private final EnumMap<Side, CastleRight> castleRight;
    private final LinkedList<Long> history = new LinkedList();
    private Side sideToMove;
    private Square enPassantTarget;
    private Square enPassant;
    private Integer moveCounter;
    private Integer halfMoveCounter;
    private BoardContext context;
    private boolean enableEvents;
    private final boolean updateHistory;
    private long incrementalHashKey;
    private static final int[] SEEPieceValues;

    public Board() {
        this(new BoardContext(), true);
    }

    public Board(BoardContext gameContext, boolean updateHistory) {
        this.bitboard = new long[Piece.allPieces.length];
        this.bbSide = new long[Side.allSides.length];
        this.occupation = new Piece[Square.values().length];
        this.castleRight = new EnumMap(Side.class);
        this.backup = new LinkedList();
        this.context = gameContext;
        this.updateHistory = updateHistory;
        this.setSideToMove(Side.WHITE);
        this.setEnPassantTarget(Square.NONE);
        this.setEnPassant(Square.NONE);
        this.setMoveCounter(1);
        this.setHalfMoveCounter(0);
        this.loadFromFen(gameContext.getStartFEN());
        this.setEnableEvents(true);
    }

    private static boolean isPromoRank(Side side, Move move) {
        if (side.equals((Object)Side.WHITE) && move.getTo().getRank().equals((Object)Rank.RANK_8)) {
            return true;
        }
        return side.equals((Object)Side.BLACK) && move.getTo().getRank().equals((Object)Rank.RANK_1);
    }

    private static Square findEnPassantTarget(Square sq, Side side) {
        Square ep = Square.NONE;
        if (!Square.NONE.equals((Object)sq)) {
            ep = Side.WHITE.equals((Object)side) ? Square.encode(Rank.RANK_5, sq.getFile()) : Square.encode(Rank.RANK_4, sq.getFile());
        }
        return ep;
    }

    private static Square findEnPassant(Square sq, Side side) {
        Square ep = Square.NONE;
        if (!Square.NONE.equals((Object)sq)) {
            ep = Side.WHITE.equals((Object)side) ? Square.encode(Rank.RANK_3, sq.getFile()) : Square.encode(Rank.RANK_6, sq.getFile());
        }
        return ep;
    }

    private static IntStream zeroToSeven() {
        return IntStream.iterate(0, i -> i + 1).limit(8L);
    }

    private static IntStream sevenToZero() {
        return IntStream.iterate(7, i -> i - 1).limit(8L);
    }

    public void doMove(String move) {
        MoveList moves = new MoveList(this.getFen());
        moves.addSanMove(move, true, true);
        this.doMove(moves.removeLast());
    }

    public AccumulatorDiff doMove(Move move) {
        Piece capturedPiece;
        assert (this.isMoveLegal(move, true));
        assert (this.isMovePseudoLegal(move));
        AccumulatorDiff diff = new AccumulatorDiff();
        Piece movingPiece = this.getPiece(move.getFrom());
        Side side = this.getSideToMove();
        MoveBackup backupMove = new MoveBackup(this, move);
        boolean isCastle = this.context.isCastleMove(move);
        this.incrementalHashKey ^= this.getSideKey(this.getSideToMove());
        if (this.getEnPassantTarget() != Square.NONE) {
            this.incrementalHashKey ^= this.getEnPassantKey(this.getEnPassantTarget());
        }
        diff.removePiece(movingPiece, move.getFrom());
        if (move.isPromotion()) {
            diff.addPiece(Piece.make(this.getSideToMove(), move.getPromotion()), move.getTo());
        } else {
            diff.addPiece(movingPiece, move.getTo());
        }
        if (PieceType.KING.equals((Object)movingPiece.getPieceType())) {
            if (isCastle) {
                assert (this.context.hasCastleRight(move, this.getCastleRight(side)));
                CastleRight c = this.context.isKingSideCastle(move) ? CastleRight.KING_SIDE : CastleRight.QUEEN_SIDE;
                Move rookMove = this.context.getRookCastleMove(side, c);
                diff.removePiece(Piece.make(side, PieceType.ROOK), rookMove.getFrom());
                diff.addPiece(Piece.make(side, PieceType.ROOK), rookMove.getTo());
                this.movePiece(rookMove, backupMove);
            }
            if (this.getCastleRight(side) != CastleRight.NONE) {
                this.incrementalHashKey ^= this.getCastleRightKey(side);
                this.getCastleRight().put(side, CastleRight.NONE);
            }
        } else if (PieceType.ROOK == movingPiece.getPieceType() && CastleRight.NONE != this.getCastleRight(side)) {
            Move oo = this.context.getRookoo(side);
            Move ooo = this.context.getRookooo(side);
            if (move.getFrom() == oo.getFrom()) {
                if (CastleRight.KING_AND_QUEEN_SIDE == this.getCastleRight(side)) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                    this.getCastleRight().put(side, CastleRight.QUEEN_SIDE);
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                } else if (CastleRight.KING_SIDE == this.getCastleRight(side)) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                    this.getCastleRight().put(side, CastleRight.NONE);
                }
            } else if (move.getFrom() == ooo.getFrom()) {
                if (CastleRight.KING_AND_QUEEN_SIDE == this.getCastleRight(side)) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                    this.getCastleRight().put(side, CastleRight.KING_SIDE);
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                } else if (CastleRight.QUEEN_SIDE == this.getCastleRight(side)) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side);
                    this.getCastleRight().put(side, CastleRight.NONE);
                }
            }
        }
        if (!Piece.NONE.equals((Object)(capturedPiece = this.movePiece(move, backupMove)))) {
            Square captureSquare = move.getTo();
            if (movingPiece.getPieceType().equals((Object)PieceType.PAWN) && move.getTo() == this.getEnPassant()) {
                captureSquare = this.getEnPassantTarget();
            }
            diff.removePiece(capturedPiece, captureSquare);
        }
        if (PieceType.ROOK == capturedPiece.getPieceType()) {
            Move oo = this.context.getRookoo(side.flip());
            Move ooo = this.context.getRookooo(side.flip());
            if (move.getTo() == oo.getFrom()) {
                if (CastleRight.KING_AND_QUEEN_SIDE == this.getCastleRight(side.flip())) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                    this.getCastleRight().put(side.flip(), CastleRight.QUEEN_SIDE);
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                } else if (CastleRight.KING_SIDE == this.getCastleRight(side.flip())) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                    this.getCastleRight().put(side.flip(), CastleRight.NONE);
                }
            } else if (move.getTo() == ooo.getFrom()) {
                if (CastleRight.KING_AND_QUEEN_SIDE == this.getCastleRight(side.flip())) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                    this.getCastleRight().put(side.flip(), CastleRight.KING_SIDE);
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                } else if (CastleRight.QUEEN_SIDE == this.getCastleRight(side.flip())) {
                    this.incrementalHashKey ^= this.getCastleRightKey(side.flip());
                    this.getCastleRight().put(side.flip(), CastleRight.NONE);
                }
            }
        }
        if (Piece.NONE == capturedPiece) {
            this.setHalfMoveCounter(this.getHalfMoveCounter() + 1);
        } else {
            this.setHalfMoveCounter(0);
        }
        this.setEnPassantTarget(Square.NONE);
        this.setEnPassant(Square.NONE);
        if (PieceType.PAWN == movingPiece.getPieceType()) {
            if (Math.abs(move.getTo().getRank().ordinal() - move.getFrom().getRank().ordinal()) == 2) {
                Piece otherPawn = Piece.make(side.flip(), PieceType.PAWN);
                this.setEnPassant(Board.findEnPassant(move.getTo(), side));
                if (this.hasPiece(otherPawn, move.getTo().getSideSquares()) && this.verifyNotPinnedPiece(side, this.getEnPassant(), move.getTo())) {
                    this.setEnPassantTarget(move.getTo());
                    this.incrementalHashKey ^= this.getEnPassantKey(this.getEnPassantTarget());
                }
            }
            this.setHalfMoveCounter(0);
        }
        if (side == Side.BLACK) {
            this.setMoveCounter(this.getMoveCounter() + 1);
        }
        this.setSideToMove(side.flip());
        this.incrementalHashKey ^= this.getSideKey(this.getSideToMove());
        if (this.updateHistory) {
            this.getHistory().addLast(this.getIncrementalHashKey());
        }
        this.backup.add(backupMove);
        return diff;
    }

    public boolean doNullMove() {
        Side side = this.getSideToMove();
        MoveBackup backupMove = new MoveBackup(this, Constants.emptyMove);
        this.setHalfMoveCounter(this.getHalfMoveCounter() + 1);
        this.setEnPassantTarget(Square.NONE);
        this.setEnPassant(Square.NONE);
        this.incrementalHashKey ^= this.getSideKey(this.getSideToMove());
        this.setSideToMove(side.flip());
        this.incrementalHashKey ^= this.getSideKey(this.getSideToMove());
        if (this.updateHistory) {
            this.getHistory().addLast(this.getIncrementalHashKey());
        }
        this.backup.add(backupMove);
        return true;
    }

    public Move undoMove() {
        Move move = null;
        MoveBackup b = this.backup.removeLast();
        if (this.updateHistory) {
            this.getHistory().removeLast();
        }
        if (b != null) {
            move = b.getMove();
            b.restore(this);
        }
        return move;
    }

    protected Piece movePiece(Move move, MoveBackup backup) {
        return this.movePiece(move.getFrom(), move.getTo(), Piece.make(this.getSideToMove(), move.getPromotion()), backup);
    }

    protected Piece movePiece(Square from, Square to, Piece promotion, MoveBackup backup) {
        Piece movingPiece = this.getPiece(from);
        Piece capturedPiece = this.getPiece(to);
        this.unsetPiece(movingPiece, from);
        if (!Piece.NONE.equals((Object)capturedPiece)) {
            this.unsetPiece(capturedPiece, to);
        }
        if (!Piece.NONE.equals((Object)promotion)) {
            this.setPiece(promotion, to);
        } else {
            this.setPiece(movingPiece, to);
        }
        if (PieceType.PAWN.equals((Object)movingPiece.getPieceType()) && !Square.NONE.equals((Object)this.getEnPassantTarget()) && !to.getFile().equals((Object)from.getFile()) && Piece.NONE.equals((Object)capturedPiece)) {
            capturedPiece = this.getPiece(this.getEnPassantTarget());
            if (backup != null && !Piece.NONE.equals((Object)capturedPiece)) {
                this.unsetPiece(capturedPiece, this.getEnPassantTarget());
                backup.setCapturedSquare(this.getEnPassantTarget());
                backup.setCapturedPiece(capturedPiece);
            }
        }
        return capturedPiece;
    }

    protected void undoMovePiece(Move move) {
        Square from = move.getFrom();
        Square to = move.getTo();
        Piece promotion = Piece.make(this.getSideToMove(), move.getPromotion());
        Piece movingPiece = this.getPiece(to);
        this.unsetPiece(movingPiece, to);
        if (!Piece.NONE.equals((Object)promotion)) {
            this.setPiece(Piece.make(this.getSideToMove(), PieceType.PAWN), from);
        } else {
            this.setPiece(movingPiece, from);
        }
    }

    public boolean hasPiece(Piece piece, Square[] location) {
        for (Square sq : location) {
            if ((this.getBitboard(piece) & sq.getBitboard()) == 0L) continue;
            return true;
        }
        return false;
    }

    public Piece getPiece(Square sq) {
        return this.occupation[sq.ordinal()];
    }

    public long getBitboard() {
        return this.bbSide[0] | this.bbSide[1];
    }

    public long getBitboard(Piece piece) {
        return this.bitboard[piece.ordinal()];
    }

    public long getBitboard(Side side, PieceType pieceType) {
        return this.bitboard[Piece.make(side, pieceType).ordinal()];
    }

    public long getBitboard(PieceType pieceType) {
        return this.bitboard[Piece.make(Side.WHITE, pieceType).ordinal()] | this.bitboard[Piece.make(Side.BLACK, pieceType).ordinal()];
    }

    public long getBitboard(Side side) {
        return this.bbSide[side.ordinal()];
    }

    public long[] getBbSide() {
        return this.bbSide;
    }

    public List<Square> getPieceLocation(Piece piece) {
        if (this.getBitboard(piece) != 0L) {
            return Bitboard.bbToSquareList(this.getBitboard(piece));
        }
        return Collections.emptyList();
    }

    public Square getFistPieceLocation(Piece piece) {
        if (this.getBitboard(piece) != 0L) {
            return Square.squareAt(Bitboard.bitScanForward(this.getBitboard(piece)));
        }
        return Square.NONE;
    }

    public Side getSideToMove() {
        return this.sideToMove;
    }

    public void setSideToMove(Side sideToMove) {
        this.sideToMove = sideToMove;
    }

    public Square getEnPassantTarget() {
        return this.enPassantTarget;
    }

    public void setEnPassantTarget(Square enPassant) {
        this.enPassantTarget = enPassant;
    }

    public Square getEnPassant() {
        return this.enPassant;
    }

    public void setEnPassant(Square enPassant) {
        this.enPassant = enPassant;
    }

    public Integer getMoveCounter() {
        return this.moveCounter;
    }

    public void setMoveCounter(Integer moveCounter) {
        this.moveCounter = moveCounter;
    }

    public Integer getHalfMoveCounter() {
        return this.halfMoveCounter;
    }

    public void setHalfMoveCounter(Integer halfMoveCounter) {
        this.halfMoveCounter = halfMoveCounter;
    }

    public CastleRight getCastleRight(Side side) {
        return this.castleRight.get((Object)side);
    }

    public EnumMap<Side, CastleRight> getCastleRight() {
        return this.castleRight;
    }

    public BoardContext getContext() {
        return this.context;
    }

    public void setContext(BoardContext context) {
        this.context = context;
    }

    public LinkedList<MoveBackup> getBackup() {
        return this.backup;
    }

    public void clear() {
        this.setSideToMove(Side.WHITE);
        this.setEnPassantTarget(Square.NONE);
        this.setEnPassant(Square.NONE);
        this.setMoveCounter(0);
        this.setHalfMoveCounter(0);
        this.getHistory().clear();
        Arrays.fill(this.bitboard, 0L);
        Arrays.fill(this.bbSide, 0L);
        Arrays.fill((Object[])this.occupation, (Object)Piece.NONE);
        this.backup.clear();
        this.incrementalHashKey = 0L;
    }

    public void setPiece(Piece piece, Square sq) {
        int n = piece.ordinal();
        this.bitboard[n] = this.bitboard[n] | sq.getBitboard();
        int n2 = piece.getPieceSide().ordinal();
        this.bbSide[n2] = this.bbSide[n2] | sq.getBitboard();
        this.occupation[sq.ordinal()] = piece;
        if (piece != Piece.NONE && sq != Square.NONE) {
            this.incrementalHashKey ^= this.getPieceSquareKey(piece, sq);
        }
    }

    public void unsetPiece(Piece piece, Square sq) {
        int n = piece.ordinal();
        this.bitboard[n] = this.bitboard[n] ^ sq.getBitboard();
        int n2 = piece.getPieceSide().ordinal();
        this.bbSide[n2] = this.bbSide[n2] ^ sq.getBitboard();
        this.occupation[sq.ordinal()] = Piece.NONE;
        if (piece != Piece.NONE && sq != Square.NONE) {
            this.incrementalHashKey ^= this.getPieceSquareKey(piece, sq);
        }
    }

    public void loadFromFen(String fen) {
        this.clear();
        String squares = fen.substring(0, fen.indexOf(32));
        String state = fen.substring(fen.indexOf(32) + 1);
        String[] ranks = squares.split("/");
        int rank = 7;
        for (String r : ranks) {
            int file = 0;
            for (int i = 0; i < r.length(); ++i) {
                char c = r.charAt(i);
                if (Character.isDigit(c)) {
                    file += Character.digit(c, 10);
                    continue;
                }
                Square sq = Square.encode(Rank.allRanks[rank], File.allFiles[file]);
                this.setPiece(Piece.fromFenSymbol(String.valueOf(c)), sq);
                ++file;
            }
            --rank;
        }
        Side side = this.sideToMove = state.toLowerCase().charAt(0) == 'w' ? Side.WHITE : Side.BLACK;
        if (state.contains("KQ")) {
            this.castleRight.put(Side.WHITE, CastleRight.KING_AND_QUEEN_SIDE);
        } else if (state.contains("K")) {
            this.castleRight.put(Side.WHITE, CastleRight.KING_SIDE);
        } else if (state.contains("Q")) {
            this.castleRight.put(Side.WHITE, CastleRight.QUEEN_SIDE);
        } else {
            this.castleRight.put(Side.WHITE, CastleRight.NONE);
        }
        if (state.contains("kq")) {
            this.castleRight.put(Side.BLACK, CastleRight.KING_AND_QUEEN_SIDE);
        } else if (state.contains("k")) {
            this.castleRight.put(Side.BLACK, CastleRight.KING_SIDE);
        } else if (state.contains("q")) {
            this.castleRight.put(Side.BLACK, CastleRight.QUEEN_SIDE);
        } else {
            this.castleRight.put(Side.BLACK, CastleRight.NONE);
        }
        String[] flags = state.split(" ");
        if (flags.length >= 3) {
            String s = flags[2].toUpperCase().trim();
            if (!s.equals("-")) {
                Square ep = Square.valueOf(s);
                this.setEnPassant(ep);
                this.setEnPassantTarget(Board.findEnPassantTarget(ep, this.sideToMove));
                if (!this.pawnCanBeCapturedEnPassant()) {
                    this.setEnPassantTarget(Square.NONE);
                }
            } else {
                this.setEnPassant(Square.NONE);
                this.setEnPassantTarget(Square.NONE);
            }
            if (flags.length >= 4) {
                this.halfMoveCounter = Integer.parseInt(flags[3]);
                if (flags.length >= 5) {
                    this.moveCounter = Integer.parseInt(flags[4]);
                }
            }
        }
        this.incrementalHashKey = this.getZobristKey();
        if (this.updateHistory) {
            this.getHistory().addLast(this.getZobristKey());
        }
    }

    public String getFen() {
        return this.getFen(true);
    }

    public String getFen(boolean includeCounters) {
        return this.getFen(includeCounters, false);
    }

    public String getFen(boolean includeCounters, boolean onlyOutputEnPassantIfCapturable) {
        StringBuffer fen = new StringBuffer();
        int emptySquares = 0;
        for (int i = 7; i >= 0; --i) {
            Rank r = Rank.allRanks[i];
            if (r == Rank.NONE) continue;
            for (File f : File.allFiles) {
                if (f == File.NONE) continue;
                Square sq = Square.encode(r, f);
                Piece piece = this.getPiece(sq);
                if (Piece.NONE.equals((Object)piece)) {
                    ++emptySquares;
                } else {
                    if (emptySquares > 0) {
                        fen.append(emptySquares);
                        emptySquares = 0;
                    }
                    fen.append(piece.getFenSymbol());
                }
                if (f != File.FILE_H) continue;
                if (emptySquares > 0) {
                    fen.append(emptySquares);
                    emptySquares = 0;
                }
                if (r == Rank.RANK_1) continue;
                fen.append("/");
            }
        }
        if (Side.WHITE.equals((Object)this.sideToMove)) {
            fen.append(" w");
        } else {
            fen.append(" b");
        }
        Object rights = "";
        if (CastleRight.KING_AND_QUEEN_SIDE.equals((Object)this.castleRight.get((Object)Side.WHITE))) {
            rights = (String)rights + "KQ";
        } else if (CastleRight.KING_SIDE.equals((Object)this.castleRight.get((Object)Side.WHITE))) {
            rights = (String)rights + "K";
        } else if (CastleRight.QUEEN_SIDE.equals((Object)this.castleRight.get((Object)Side.WHITE))) {
            rights = (String)rights + "Q";
        }
        if (CastleRight.KING_AND_QUEEN_SIDE.equals((Object)this.castleRight.get((Object)Side.BLACK))) {
            rights = (String)rights + "kq";
        } else if (CastleRight.KING_SIDE.equals((Object)this.castleRight.get((Object)Side.BLACK))) {
            rights = (String)rights + "k";
        } else if (CastleRight.QUEEN_SIDE.equals((Object)this.castleRight.get((Object)Side.BLACK))) {
            rights = (String)rights + "q";
        }
        if (StringUtils.isEmpty((CharSequence)rights)) {
            fen.append(" -");
        } else {
            fen.append(" " + (String)rights);
        }
        if (Square.NONE.equals((Object)this.getEnPassant()) || onlyOutputEnPassantIfCapturable && !this.pawnCanBeCapturedEnPassant()) {
            fen.append(" -");
        } else {
            fen.append(" ");
            fen.append(this.getEnPassant().toString().toLowerCase());
        }
        if (includeCounters) {
            fen.append(" ");
            fen.append(this.getHalfMoveCounter());
            fen.append(" ");
            fen.append(this.getMoveCounter());
        }
        return fen.toString();
    }

    public Piece[] boardToArray() {
        Piece[] pieces = new Piece[65];
        pieces[64] = Piece.NONE;
        for (Square square : Square.values()) {
            if (Square.NONE.equals((Object)square)) continue;
            pieces[square.ordinal()] = this.getPiece(square);
        }
        return pieces;
    }

    public long squareAttackedBy(Square square, Side side) {
        return this.squareAttackedBy(square, side, this.getBitboard());
    }

    public long squareAttackedBy(Square square, Side side, long occ) {
        long result = Attacks.getPawnAttacks(side.flip(), square.getBitboard()) & this.getBitboard(Piece.make(side, PieceType.PAWN)) & occ;
        result |= Attacks.getKnightAttacks(square, occ) & this.getBitboard(Piece.make(side, PieceType.KNIGHT));
        result |= Attacks.getBishopAttacks(occ, square) & (this.getBitboard(Piece.make(side, PieceType.BISHOP)) | this.getBitboard(Piece.make(side, PieceType.QUEEN)));
        result |= Attacks.getRookAttacks(occ, square) & (this.getBitboard(Piece.make(side, PieceType.ROOK)) | this.getBitboard(Piece.make(side, PieceType.QUEEN)));
        return result |= Attacks.getKingAttacks(square, occ) & this.getBitboard(Piece.make(side, PieceType.KING));
    }

    public long squareAttackedByPieceType(Square square, Side side, PieceType type) {
        return this.squareAttackedByPieceType(square, side, type, this.getBitboard());
    }

    public long squareAttackedByPieceType(Square square, Side side, PieceType type, long occ) {
        long result = 0L;
        switch (type) {
            case PAWN: {
                result = Attacks.getPawnAttacks(side.flip(), square.getBitboard()) & this.getBitboard(Piece.make(side, PieceType.PAWN));
                break;
            }
            case KNIGHT: {
                result = Attacks.getKnightAttacks(square, occ) & this.getBitboard(Piece.make(side, PieceType.KNIGHT));
                break;
            }
            case BISHOP: {
                result = Attacks.getBishopAttacks(occ, square) & this.getBitboard(Piece.make(side, PieceType.BISHOP));
                break;
            }
            case ROOK: {
                result = Attacks.getRookAttacks(occ, square) & this.getBitboard(Piece.make(side, PieceType.ROOK));
                break;
            }
            case QUEEN: {
                result = Attacks.getQueenAttacks(occ, square) & this.getBitboard(Piece.make(side, PieceType.QUEEN));
                break;
            }
            case KING: {
                result |= Attacks.getKingAttacks(square, occ) & this.getBitboard(Piece.make(side, PieceType.KING));
                break;
            }
        }
        return result;
    }

    public Square getKingSquare(Side side) {
        Square result = Square.NONE;
        long piece = this.getBitboard(Piece.make(side, PieceType.KING));
        if (piece != 0L) {
            int sq = Bitboard.bitScanForward(piece);
            return Square.squareAt(sq);
        }
        return result;
    }

    public boolean isKingAttacked() {
        return this.squareAttackedBy(this.getKingSquare(this.getSideToMove()), this.getSideToMove().flip()) != 0L;
    }

    private boolean isAttackedByPiece(Square from, long to, PieceType pt, long occ) {
        switch (pt) {
            case PAWN: {
                return 0L != (to & Attacks.getPawnAttacks(this.getSideToMove(), from.getBitboard()));
            }
            case KNIGHT: {
                return 0L != (to & Attacks.getKnightAttacks(from, occ));
            }
            case BISHOP: {
                return 0L != (to & Attacks.getBishopAttacks(occ, from));
            }
            case ROOK: {
                return 0L != (to & Attacks.getRookAttacks(occ, from));
            }
            case QUEEN: {
                return 0L != (to & Attacks.getQueenAttacks(occ, from));
            }
        }
        return false;
    }

    public boolean attacksKing(Move move) {
        PieceType moved = this.getPiece(move.getFrom()).getPieceType();
        long occ = this.getBitboard();
        long king = this.getBitboard(Piece.make(this.getSideToMove().flip(), PieceType.KING));
        if (this.isAttackedByPiece(move.getTo(), king, moved, this.getBitboard())) {
            return true;
        }
        Square kingSquare = Square.squareAt(Bitboard.bitScanForward(king));
        long newOcc = occ ^ move.getFrom().getBitboard() | move.getTo().getBitboard();
        long newBishopAttacks = Attacks.getBishopAttacks(newOcc, kingSquare);
        long newRookAttacks = Attacks.getRookAttacks(newOcc, kingSquare);
        long bishops = this.getBitboard(Piece.make(this.getSideToMove(), PieceType.BISHOP));
        long rooks = this.getBitboard(Piece.make(this.getSideToMove(), PieceType.ROOK));
        long queens = this.getBitboard(Piece.make(this.getSideToMove(), PieceType.QUEEN));
        if (0L != ((bishops | queens) & newBishopAttacks)) {
            return true;
        }
        if (0L != ((rooks | queens) & newRookAttacks)) {
            return true;
        }
        if (!move.getPromotion().equals((Object)PieceType.NONE)) {
            return this.isAttackedByPiece(move.getTo(), king, move.getPromotion(), newOcc);
        }
        if (PieceType.KING.equals((Object)moved)) {
            if (move.equals(this.context.getWhiteoo())) {
                return 0L != (newRookAttacks & this.context.getWhiteRookoo().getTo().getBitboard());
            }
            if (move.equals(this.context.getWhiteooo())) {
                return 0L != (newRookAttacks & this.context.getWhiteRookooo().getTo().getBitboard());
            }
            if (move.equals(this.context.getBlackoo())) {
                return 0L != (newRookAttacks & this.context.getBlackRookoo().getTo().getBitboard());
            }
            if (move.equals(this.context.getBlackooo())) {
                return 0L != (newRookAttacks & this.context.getBlackRookooo().getTo().getBitboard());
            }
        }
        return false;
    }

    public boolean isSquareAttackedBy(List<Square> squares, Side side) {
        for (Square sq : squares) {
            if (this.squareAttackedBy(sq, side) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isMovePseudoLegal(Move move) {
        if (Piece.NONE.equals((Object)this.getPiece(move.getFrom())) || !this.isMoveLegal(move, true)) {
            return false;
        }
        Square from = move.getFrom();
        Square to = move.getTo();
        Piece movedPiece = this.getPiece(move.getFrom());
        Side side = movedPiece.getPieceSide();
        PieceType movedPieceType = movedPiece.getPieceType();
        long occupied = this.getBitboard();
        if (movedPiece.getPieceType().equals((Object)PieceType.KING) && this.getContext().isCastleMove(move)) {
            return !this.isKingAttacked();
        }
        if (0L != (this.getBitboard(side) & to.getBitboard())) {
            return false;
        }
        switch (movedPieceType) {
            case PAWN: {
                long pawnThreats = Attacks.getPawnCaptures(side, from.getBitboard(), to.getBitboard() & (this.getBitboard(side.flip()) | this.getEnPassant().getBitboard()), this.getEnPassant()) & to.getBitboard();
                return 0L != (pawnThreats |= Attacks.getPawnMoves(side, from.getBitboard(), occupied) & to.getBitboard());
            }
            case KNIGHT: {
                return 0L != Attacks.getKnightAttacks(from, to.getBitboard());
            }
            case BISHOP: {
                return 0L != (Attacks.getBishopAttacks(occupied, from) & to.getBitboard());
            }
            case ROOK: {
                return 0L != (Attacks.getRookAttacks(occupied, from) & to.getBitboard());
            }
            case QUEEN: {
                return 0L != (Attacks.getQueenAttacks(occupied, from) & to.getBitboard());
            }
            case KING: {
                return 0L != Attacks.getKingAttacks(from, to.getBitboard());
            }
        }
        return false;
    }

    public boolean isMoveLegal(Move move, boolean fullValidation) {
        Piece fromPiece = this.getPiece(move.getFrom());
        Side side = this.getSideToMove();
        PieceType fromType = fromPiece.getPieceType();
        Piece capturedPiece = this.getPiece(move.getTo());
        if (fullValidation) {
            boolean hasPromoPiece;
            if (Piece.NONE.equals((Object)fromPiece)) {
                throw new RuntimeException("From piece cannot be null");
            }
            if (fromPiece.getPieceSide().equals((Object)capturedPiece.getPieceSide())) {
                return false;
            }
            if (!side.equals((Object)fromPiece.getPieceSide())) {
                return false;
            }
            boolean pawnPromoting = fromPiece.getPieceType().equals((Object)PieceType.PAWN) && Board.isPromoRank(side, move);
            boolean bl = hasPromoPiece = !move.getPromotion().equals((Object)PieceType.NONE);
            if (hasPromoPiece != pawnPromoting) {
                return false;
            }
            if (fromType.equals((Object)PieceType.KING)) {
                if (this.getContext().isKingSideCastle(move)) {
                    if ((this.getCastleRight(side).equals((Object)CastleRight.KING_AND_QUEEN_SIDE) || this.getCastleRight(side).equals((Object)CastleRight.KING_SIDE)) && (this.getBitboard() & this.getContext().getooAllSquaresBb(side)) == 0L) {
                        return !this.isSquareAttackedBy(this.getContext().getooSquares(side), side.flip());
                    }
                    return false;
                }
                if (this.getContext().isQueenSideCastle(move)) {
                    if ((this.getCastleRight(side).equals((Object)CastleRight.KING_AND_QUEEN_SIDE) || this.getCastleRight(side).equals((Object)CastleRight.QUEEN_SIDE)) && (this.getBitboard() & this.getContext().getoooAllSquaresBb(side)) == 0L) {
                        return !this.isSquareAttackedBy(this.getContext().getoooSquares(side), side.flip());
                    }
                    return false;
                }
            }
        }
        if (fromType.equals((Object)PieceType.KING) && this.squareAttackedBy(move.getTo(), side.flip()) != 0L) {
            return false;
        }
        Square kingSq = fromType.equals((Object)PieceType.KING) ? move.getTo() : this.getKingSquare(side);
        Side other = side.flip();
        long moveTo = move.getTo().getBitboard();
        long moveFrom = move.getFrom().getBitboard();
        long ep = this.getEnPassantTarget() != Square.NONE && move.getTo() == this.getEnPassant() && fromType.equals((Object)PieceType.PAWN) ? this.getEnPassantTarget().getBitboard() : 0L;
        long allPieces = this.getBitboard() ^ moveFrom ^ ep | moveTo;
        long bishopAndQueens = (this.getBitboard(Piece.make(other, PieceType.BISHOP)) | this.getBitboard(Piece.make(other, PieceType.QUEEN))) & (moveTo ^ 0xFFFFFFFFFFFFFFFFL);
        if (bishopAndQueens != 0L && (Attacks.getBishopAttacks(allPieces, kingSq) & bishopAndQueens) != 0L) {
            return false;
        }
        long rookAndQueens = (this.getBitboard(Piece.make(other, PieceType.ROOK)) | this.getBitboard(Piece.make(other, PieceType.QUEEN))) & (moveTo ^ 0xFFFFFFFFFFFFFFFFL);
        if (rookAndQueens != 0L && (Attacks.getRookAttacks(allPieces, kingSq) & rookAndQueens) != 0L) {
            return false;
        }
        long knights = this.getBitboard(Piece.make(other, PieceType.KNIGHT)) & (moveTo ^ 0xFFFFFFFFFFFFFFFFL);
        if (knights != 0L && (Attacks.getKnightAttacks(kingSq, allPieces) & knights) != 0L) {
            return false;
        }
        long pawns = this.getBitboard(Piece.make(other, PieceType.PAWN)) & (moveTo ^ 0xFFFFFFFFFFFFFFFFL) & (ep ^ 0xFFFFFFFFFFFFFFFFL);
        return pawns == 0L || (Attacks.getPawnAttacks(side, kingSq.getBitboard()) & pawns) == 0L;
    }

    public boolean isAttackedBy(Move move) {
        PieceType pieceType = this.getPiece(move.getFrom()).getPieceType();
        assert (!PieceType.NONE.equals((Object)pieceType));
        Side side = this.getSideToMove();
        long attacks = 0L;
        switch (pieceType) {
            case PAWN: {
                if (!move.getFrom().getFile().equals((Object)move.getTo().getFile())) {
                    attacks = Attacks.getPawnCaptures(side, move.getFrom().getBitboard(), this.getBitboard(), this.getEnPassantTarget());
                    break;
                }
                attacks = Attacks.getPawnMoves(side, move.getFrom().getBitboard(), this.getBitboard());
                break;
            }
            case KNIGHT: {
                attacks = Attacks.getKnightAttacks(move.getFrom(), this.getBitboard(side) ^ 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            case BISHOP: {
                attacks = Attacks.getBishopAttacks(this.getBitboard(), move.getFrom());
                break;
            }
            case ROOK: {
                attacks = Attacks.getRookAttacks(this.getBitboard(), move.getFrom());
                break;
            }
            case QUEEN: {
                attacks = Attacks.getQueenAttacks(this.getBitboard(), move.getFrom());
                break;
            }
            case KING: {
                attacks = Attacks.getKingAttacks(move.getFrom(), this.getBitboard(side) ^ 0xFFFFFFFFFFFFFFFFL);
                break;
            }
        }
        return (attacks & move.getTo().getBitboard()) != 0L;
    }

    public LinkedList<Long> getHistory() {
        return this.history;
    }

    public boolean isMated() {
        try {
            if (this.isKingAttacked()) {
                LinkedList<Move> l = new LinkedList<Move>();
                MoveGenerator.generateLegalMoves(this, l);
                if (l.size() == 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean isDraw() {
        if (this.isRepetition()) {
            return true;
        }
        if (this.isInsufficientMaterial()) {
            return true;
        }
        if (this.getHalfMoveCounter() >= 100) {
            return true;
        }
        return this.isStaleMate();
    }

    public boolean isRepetition(int n) {
        int i = Math.min(this.getHistory().size() - 1, this.getHalfMoveCounter());
        if (this.getHistory().size() >= 4) {
            long lastKey = this.getHistory().get(this.getHistory().size() - 1);
            int rep = 0;
            for (int x = 4; x <= i; x += 2) {
                long k = this.getHistory().get(this.getHistory().size() - x - 1);
                if (k != lastKey || ++rep < n - 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRepetition() {
        return this.isRepetition(3);
    }

    public boolean isInsufficientMaterial() {
        if (this.getBitboard(Piece.WHITE_QUEEN) + this.getBitboard(Piece.BLACK_QUEEN) + this.getBitboard(Piece.WHITE_ROOK) + this.getBitboard(Piece.BLACK_ROOK) != 0L) {
            return false;
        }
        long pawns = this.getBitboard(Piece.WHITE_PAWN) | this.getBitboard(Piece.BLACK_PAWN);
        if (pawns == 0L) {
            long count = Long.bitCount(this.getBitboard());
            int whiteCount = Long.bitCount(this.getBitboard(Side.WHITE));
            int blackCount = Long.bitCount(this.getBitboard(Side.BLACK));
            if (count == 4L) {
                int whiteBishopCount = Long.bitCount(this.getBitboard(Piece.WHITE_BISHOP));
                int blackBishopCount = Long.bitCount(this.getBitboard(Piece.BLACK_BISHOP));
                if (whiteCount > 1 && blackCount > 1) {
                    return whiteBishopCount != 1 || blackBishopCount != 1 || this.getFistPieceLocation(Piece.WHITE_BISHOP).isLightSquare() == this.getFistPieceLocation(Piece.BLACK_BISHOP).isLightSquare();
                }
                if (whiteCount == 3 || blackCount == 3) {
                    if (whiteBishopCount == 2 && ((0x55AA55AA55AA55AAL & this.getBitboard(Piece.WHITE_BISHOP)) == 0L || (0xAA55AA55AA55AA55L & this.getBitboard(Piece.WHITE_BISHOP)) == 0L)) {
                        return true;
                    }
                    return blackBishopCount == 2 && ((0x55AA55AA55AA55AAL & this.getBitboard(Piece.BLACK_BISHOP)) == 0L || (0xAA55AA55AA55AA55L & this.getBitboard(Piece.BLACK_BISHOP)) == 0L);
                }
                return Long.bitCount(this.getBitboard(Piece.WHITE_KNIGHT)) == 2 || Long.bitCount(this.getBitboard(Piece.BLACK_KNIGHT)) == 2;
            }
            if ((this.getBitboard(Piece.WHITE_KING) | this.getBitboard(Piece.WHITE_BISHOP)) == this.getBitboard(Side.WHITE) && (this.getBitboard(Piece.BLACK_KING) | this.getBitboard(Piece.BLACK_BISHOP)) == this.getBitboard(Side.BLACK)) {
                return (0x55AA55AA55AA55AAL & this.getBitboard(Piece.WHITE_BISHOP)) == 0L && (0x55AA55AA55AA55AAL & this.getBitboard(Piece.BLACK_BISHOP)) == 0L || (0xAA55AA55AA55AA55L & this.getBitboard(Piece.WHITE_BISHOP)) == 0L && (0xAA55AA55AA55AA55L & this.getBitboard(Piece.BLACK_BISHOP)) == 0L;
            }
            return count < 4L;
        }
        return false;
    }

    public boolean isStaleMate() {
        try {
            if (!this.isKingAttacked()) {
                LinkedList<Move> l = new LinkedList<Move>();
                MoveGenerator.generateLegalMoves(this, l);
                if (l.size() == 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean isEnableEvents() {
        return this.enableEvents;
    }

    public void setEnableEvents(boolean enableEvents) {
        this.enableEvents = enableEvents;
    }

    public String getPositionId() {
        String[] parts = this.getFen(false).split(" ");
        return parts[0] + " " + parts[1] + " " + parts[2] + (this.getEnPassantTarget() != Square.NONE ? parts[3] : "-");
    }

    public void generateLegalMoves(List<Move> moves) {
        MoveGenerator.generateLegalMoves(this, moves);
    }

    public void generatePseudoLegalMoves(List<Move> moves) {
        MoveGenerator.generatePseudoLegalMoves(this, moves);
    }

    public void generatePseudoLegalCaptures(List<Move> moves) {
        MoveGenerator.generatePseudoLegalCaptures(this, moves);
    }

    public List<Move> legalMoves() {
        LinkedList<Move> moves = new LinkedList<Move>();
        this.generateLegalMoves(moves);
        return moves;
    }

    public List<Move> pseudoLegalMoves() {
        LinkedList<Move> moves = new LinkedList<Move>();
        this.generatePseudoLegalMoves(moves);
        return moves;
    }

    public List<Move> pseudoLegalCaptures() {
        LinkedList<Move> moves = new LinkedList<Move>();
        this.generatePseudoLegalCaptures(moves);
        return moves;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Board) {
            Board board = (Board)obj;
            for (Piece piece : Piece.allPieces) {
                if (piece == Piece.NONE || this.getBitboard(piece) == board.getBitboard(piece)) continue;
                return false;
            }
            return this.getSideToMove() == board.getSideToMove() && this.getCastleRight(Side.WHITE) == board.getCastleRight(Side.WHITE) && this.getCastleRight(Side.BLACK) == board.getCastleRight(Side.BLACK) && this.getEnPassant() == board.getEnPassant() && this.getEnPassantTarget() == board.getEnPassantTarget();
        }
        return false;
    }

    public boolean strictEquals(Object obj) {
        if (obj instanceof Board) {
            Board board = (Board)obj;
            return this.equals(board) && board.getHistory().equals(this.getHistory());
        }
        return false;
    }

    public int hashCode() {
        return (int)this.incrementalHashKey;
    }

    public long getZobristKey() {
        long hash = 0L;
        if (this.getCastleRight(Side.WHITE) != CastleRight.NONE) {
            hash ^= this.getCastleRightKey(Side.WHITE);
        }
        if (this.getCastleRight(Side.BLACK) != CastleRight.NONE) {
            hash ^= this.getCastleRightKey(Side.BLACK);
        }
        for (Square sq : Square.values()) {
            Piece piece = this.getPiece(sq);
            if (Piece.NONE.equals((Object)piece) || Square.NONE.equals((Object)sq)) continue;
            hash ^= this.getPieceSquareKey(piece, sq);
        }
        hash ^= this.getSideKey(this.getSideToMove());
        if (Square.NONE != this.getEnPassantTarget() && this.pawnCanBeCapturedEnPassant()) {
            hash ^= this.getEnPassantKey(this.getEnPassantTarget());
        }
        return hash;
    }

    private long getCastleRightKey(Side side) {
        return keys.get(3 * this.getCastleRight(side).ordinal() + 300 + 3 * side.ordinal());
    }

    private long getSideKey(Side side) {
        return keys.get(3 * side.ordinal() + 500);
    }

    private long getEnPassantKey(Square enPassantTarget) {
        return keys.get(3 * enPassantTarget.ordinal() + 400);
    }

    private long getPieceSquareKey(Piece piece, Square square) {
        return keys.get(57 * piece.ordinal() + 13 * square.ordinal());
    }

    public String toStringFromWhiteViewPoint() {
        return this.toStringFromViewPoint(Side.WHITE);
    }

    public String toStringFromBlackViewPoint() {
        return this.toStringFromViewPoint(Side.BLACK);
    }

    public String toStringFromViewPoint(Side side) {
        StringBuilder sb = new StringBuilder();
        Supplier<IntStream> rankIterator = side == Side.WHITE ? Board::sevenToZero : Board::zeroToSeven;
        Supplier<IntStream> fileIterator = side == Side.WHITE ? Board::zeroToSeven : Board::sevenToZero;
        rankIterator.get().forEach(i -> {
            Rank r = Rank.allRanks[i];
            ((IntStream)fileIterator.get()).forEach(n -> {
                File f = File.allFiles[n];
                if (!File.NONE.equals((Object)f) && !Rank.NONE.equals((Object)r)) {
                    Square sq = Square.encode(r, f);
                    Piece piece = this.getPiece(sq);
                    sb.append(piece.getFenSymbol());
                }
            });
            sb.append("\n");
        });
        return sb.toString();
    }

    public String toString() {
        return this.toStringFromWhiteViewPoint() + "Side: " + String.valueOf((Object)this.getSideToMove());
    }

    public Board clone() {
        Board copy = new Board(this.getContext(), this.updateHistory);
        copy.loadFromFen(this.getFen());
        copy.setEnPassantTarget(this.getEnPassantTarget());
        copy.getHistory().clear();
        Iterator iterator = this.getHistory().iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            copy.getHistory().add(key);
        }
        return copy;
    }

    public long getIncrementalHashKey() {
        return this.incrementalHashKey;
    }

    public void setIncrementalHashKey(long hashKey) {
        this.incrementalHashKey = hashKey;
    }

    public boolean hasNonPawnMaterial(Side side) {
        return (this.getBitboard(Piece.make(side, PieceType.KING)) | this.getBitboard(Piece.make(side, PieceType.PAWN))) != this.getBitboard(side);
    }

    public boolean hasNonPawnMaterial() {
        return this.hasNonPawnMaterial(this.getSideToMove());
    }

    public int moveEstimatedValue(Move move) {
        int value;
        int n = value = !this.getPiece(move.getTo()).equals((Object)Piece.NONE) ? SEEPieceValues[this.getPiece(move.getTo()).getPieceType().ordinal()] : 0;
        if (move.isPromotion()) {
            value += SEEPieceValues[move.getPromotion().ordinal()] - SEEPieceValues[PieceType.PAWN.ordinal()];
        } else if (PieceType.PAWN.equals((Object)this.getPiece(move.getFrom()).getPieceType()) && this.getEnPassant().equals((Object)move.getTo())) {
            value = SEEPieceValues[PieceType.PAWN.ordinal()];
        }
        return value;
    }

    public boolean staticExchangeEvaluation(Move move, int threshold) {
        long myAttackers;
        Square from = move.getFrom();
        Square to = move.getTo();
        boolean isPromotion = move.isPromotion();
        boolean isEnPassant = PieceType.PAWN.equals((Object)this.getPiece(from).getPieceType()) && this.getEnPassant().equals((Object)to);
        PieceType nextVictim = !isPromotion ? this.getPiece(from).getPieceType() : move.getPromotion();
        int balance = this.moveEstimatedValue(move) - threshold;
        if (balance < 0) {
            return false;
        }
        if ((balance -= SEEPieceValues[nextVictim.ordinal()]) >= 0) {
            return true;
        }
        long bishops = this.getBitboard(PieceType.BISHOP) | this.getBitboard(PieceType.QUEEN);
        long rooks = this.getBitboard(PieceType.ROOK) | this.getBitboard(PieceType.QUEEN);
        long occupied = this.getBitboard();
        occupied = occupied ^ from.getBitboard() | to.getBitboard();
        if (isEnPassant) {
            occupied ^= this.getEnPassant().getBitboard();
        }
        long attackers = this.squareAttackedBy(to, this.getSideToMove(), occupied) | this.squareAttackedBy(to, this.getSideToMove().flip(), occupied) & occupied;
        Side color = this.getSideToMove().flip();
        while ((myAttackers = attackers & this.getBitboard(color)) != 0L) {
            if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.PAWN)))) {
                nextVictim = PieceType.PAWN;
            } else if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.KNIGHT)))) {
                nextVictim = PieceType.KNIGHT;
            } else if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.BISHOP)))) {
                nextVictim = PieceType.BISHOP;
            } else if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.ROOK)))) {
                nextVictim = PieceType.ROOK;
            } else if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.QUEEN)))) {
                nextVictim = PieceType.QUEEN;
            } else if (0L != (myAttackers & this.getBitboard(Piece.make(color, PieceType.KING)))) {
                nextVictim = PieceType.KING;
            } else assert (false);
            occupied ^= 1L << Bitboard.bitScanForward(myAttackers & this.getBitboard(Piece.make(color, nextVictim)));
            if (nextVictim.equals((Object)PieceType.PAWN) || nextVictim.equals((Object)PieceType.BISHOP) || nextVictim.equals((Object)PieceType.QUEEN)) {
                attackers |= Attacks.getBishopAttacks(occupied, to) & bishops;
            }
            if (nextVictim.equals((Object)PieceType.ROOK) || nextVictim.equals((Object)PieceType.QUEEN)) {
                attackers |= Attacks.getRookAttacks(occupied, to) & rooks;
            }
            attackers &= occupied;
            color = color.flip();
            if ((balance = -balance - 1 - SEEPieceValues[nextVictim.ordinal()]) < 0) continue;
            if (!nextVictim.equals((Object)PieceType.KING) || (attackers & this.getBitboard(color)) == 0L) break;
            color = color.flip();
            break;
        }
        return !this.getSideToMove().equals((Object)color);
    }

    public boolean isQuiet(Move move) {
        return !this.isPromotion(move) && !this.isCapture(move);
    }

    public boolean isCapture(Move move) {
        return !Piece.NONE.equals((Object)this.getPiece(move.getTo())) || PieceType.PAWN.equals((Object)this.getPiece(move.getFrom()).getPieceType()) && move.getTo() == this.getEnPassant();
    }

    public boolean isPromotion(Move move) {
        return move.isPromotion();
    }

    private boolean pawnCanBeCapturedEnPassant() {
        return this.squareAttackedByPieceType(this.getEnPassant(), this.getSideToMove(), PieceType.PAWN) != 0L && this.verifyNotPinnedPiece(this.getSideToMove().flip(), this.getEnPassant(), this.getEnPassantTarget());
    }

    private boolean verifyNotPinnedPiece(Side side, Square enPassant, Square target) {
        long pawns = Attacks.getPawnAttacks(side, enPassant.getBitboard()) & this.getBitboard(Piece.make(side.flip(), PieceType.PAWN));
        return pawns != 0L && this.verifyAllPins(pawns, side, enPassant, target);
    }

    private boolean verifyAllPins(long pawns, Side side, Square enPassant, Square target) {
        long onePawn = Bitboard.extractLsb(pawns);
        long otherPawn = pawns ^ onePawn;
        if (onePawn != 0L && this.verifyKingIsNotAttackedWithoutPin(side, enPassant, target, onePawn)) {
            return true;
        }
        return this.verifyKingIsNotAttackedWithoutPin(side, enPassant, target, otherPawn);
    }

    private boolean verifyKingIsNotAttackedWithoutPin(Side side, Square enPassant, Square target, long pawns) {
        return this.squareAttackedBy(this.getKingSquare(side.flip()), side, this.removePieces(enPassant, target, pawns)) == 0L;
    }

    private long removePieces(Square enPassant, Square target, long pieces) {
        return this.getBitboard() ^ pieces ^ target.getBitboard() | enPassant.getBitboard();
    }

    static {
        XorShiftRandom random = new XorShiftRandom(49109794719L);
        for (int i = 0; i < 2000; ++i) {
            long key = random.nextLong();
            keys.add(key);
        }
        SEEPieceValues = new int[]{103, 422, 437, 694, 1313, 0};
    }
}

