/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess;

import java.util.List;
import org.shawn.games.Serendipity.Chess.CastleRight;
import org.shawn.games.Serendipity.Chess.Constants;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;

public class BoardContext {
    protected Move whiteoo;
    protected Move whiteooo;
    protected Move blackoo;
    protected Move blackooo;
    protected Move whiteRookoo;
    protected Move whiteRookooo;
    protected Move blackRookoo;
    protected Move blackRookooo;
    protected List<Square> whiteooSquares;
    protected List<Square> whiteoooSquares;
    protected List<Square> blackooSquares;
    protected List<Square> blackoooSquares;
    protected long whiteooSquaresBb;
    protected long whiteoooSquaresBb;
    protected long blackooSquaresBb;
    protected long blackoooSquaresBb;
    protected long whiteooAllSquaresBb;
    protected long whiteoooAllSquaresBb;
    protected long blackooAllSquaresBb;
    protected long blackoooAllSquaresBb;
    protected String startFEN;

    public BoardContext() {
        this.loadDefaults();
    }

    private static long squareListToBb(List<Square> list) {
        long r = 0L;
        for (Square s : list) {
            r |= s.getBitboard();
        }
        return r;
    }

    private void loadDefaults() {
        this.setWhiteoo(Constants.DEFAULT_WHITE_OO);
        this.setWhiteooo(Constants.DEFAULT_WHITE_OOO);
        this.setBlackoo(Constants.DEFAULT_BLACK_OO);
        this.setBlackooo(Constants.DEFAULT_BLACK_OOO);
        this.setWhiteRookoo(Constants.DEFAULT_WHITE_ROOK_OO);
        this.setWhiteRookooo(Constants.DEFAULT_WHITE_ROOK_OOO);
        this.setBlackRookoo(Constants.DEFAULT_BLACK_ROOK_OO);
        this.setBlackRookooo(Constants.DEFAULT_BLACK_ROOK_OOO);
        this.setWhiteooSquares(Constants.DEFAULT_WHITE_OO_SQUARES);
        this.setWhiteoooSquares(Constants.DEFAULT_WHITE_OOO_SQUARES);
        this.setBlackooSquares(Constants.DEFAULT_BLACK_OO_SQUARES);
        this.setBlackoooSquares(Constants.DEFAULT_BLACK_OOO_SQUARES);
        this.setWhiteooSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_WHITE_OO_SQUARES));
        this.setWhiteoooSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_WHITE_OOO_SQUARES));
        this.setBlackooSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_BLACK_OO_SQUARES));
        this.setBlackoooSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_BLACK_OOO_SQUARES));
        this.setWhiteooAllSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_WHITE_OO_ALL_SQUARES));
        this.setWhiteoooAllSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_WHITE_OOO_ALL_SQUARES));
        this.setBlackooAllSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_BLACK_OO_ALL_SQUARES));
        this.setBlackoooAllSquaresBb(BoardContext.squareListToBb(Constants.DEFAULT_BLACK_OOO_ALL_SQUARES));
        this.setStartFEN("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    }

    public Move getKingCastleMove(Side side, CastleRight castleRight) {
        Move move = null;
        if (Side.WHITE.equals((Object)side)) {
            if (CastleRight.KING_SIDE.equals((Object)castleRight)) {
                move = this.getWhiteoo();
            } else if (CastleRight.QUEEN_SIDE.equals((Object)castleRight)) {
                move = this.getWhiteooo();
            }
        } else if (CastleRight.KING_SIDE.equals((Object)castleRight)) {
            move = this.getBlackoo();
        } else if (CastleRight.QUEEN_SIDE.equals((Object)castleRight)) {
            move = this.getBlackooo();
        }
        return move;
    }

    public Move getRookCastleMove(Side side, CastleRight castleRight) {
        Move move = null;
        if (Side.WHITE.equals((Object)side)) {
            if (CastleRight.KING_SIDE.equals((Object)castleRight)) {
                move = this.getWhiteRookoo();
            } else if (CastleRight.QUEEN_SIDE.equals((Object)castleRight)) {
                move = this.getWhiteRookooo();
            }
        } else if (CastleRight.KING_SIDE.equals((Object)castleRight)) {
            move = this.getBlackRookoo();
        } else if (CastleRight.QUEEN_SIDE.equals((Object)castleRight)) {
            move = this.getBlackRookooo();
        }
        return move;
    }

    public boolean isCastleMove(Move move) {
        return move.equals(this.getWhiteoo()) || move.equals(this.getWhiteooo()) || move.equals(this.getBlackoo()) || move.equals(this.getBlackooo());
    }

    public boolean hasCastleRight(Move move, CastleRight castleRight) {
        CastleRight r = castleRight;
        return CastleRight.KING_AND_QUEEN_SIDE.equals((Object)r) || move.equals(this.getWhiteoo()) && CastleRight.KING_SIDE.equals((Object)r) || move.equals(this.getBlackoo()) && CastleRight.KING_SIDE.equals((Object)r) || move.equals(this.getWhiteooo()) && CastleRight.QUEEN_SIDE.equals((Object)r) || move.equals(this.getBlackooo()) && CastleRight.QUEEN_SIDE.equals((Object)r);
    }

    public boolean isKingSideCastle(Move move) {
        return move.equals(this.getWhiteoo()) || move.equals(this.getBlackoo());
    }

    public boolean isQueenSideCastle(Move move) {
        return move.equals(this.getWhiteooo()) || move.equals(this.getBlackooo());
    }

    public Move getWhiteoo() {
        return this.whiteoo;
    }

    public void setWhiteoo(Move whiteoo) {
        this.whiteoo = whiteoo;
    }

    public Move getWhiteooo() {
        return this.whiteooo;
    }

    public void setWhiteooo(Move whiteooo) {
        this.whiteooo = whiteooo;
    }

    public Move getBlackoo() {
        return this.blackoo;
    }

    public void setBlackoo(Move blackoo) {
        this.blackoo = blackoo;
    }

    public Move getBlackooo() {
        return this.blackooo;
    }

    public void setBlackooo(Move blackooo) {
        this.blackooo = blackooo;
    }

    public Move getWhiteRookoo() {
        return this.whiteRookoo;
    }

    public void setWhiteRookoo(Move whiteRookoo) {
        this.whiteRookoo = whiteRookoo;
    }

    public Move getWhiteRookooo() {
        return this.whiteRookooo;
    }

    public void setWhiteRookooo(Move whiteRookooo) {
        this.whiteRookooo = whiteRookooo;
    }

    public Move getBlackRookoo() {
        return this.blackRookoo;
    }

    public void setBlackRookoo(Move blackRookoo) {
        this.blackRookoo = blackRookoo;
    }

    public Move getBlackRookooo() {
        return this.blackRookooo;
    }

    public void setBlackRookooo(Move blackRookooo) {
        this.blackRookooo = blackRookooo;
    }

    public String getStartFEN() {
        return this.startFEN;
    }

    public void setStartFEN(String startFEN) {
        this.startFEN = startFEN;
    }

    public List<Square> getWhiteooSquares() {
        return this.whiteooSquares;
    }

    public void setWhiteooSquares(List<Square> whiteooSquares) {
        this.whiteooSquares = whiteooSquares;
    }

    public List<Square> getWhiteoooSquares() {
        return this.whiteoooSquares;
    }

    public void setWhiteoooSquares(List<Square> whiteoooSquares) {
        this.whiteoooSquares = whiteoooSquares;
    }

    public List<Square> getBlackooSquares() {
        return this.blackooSquares;
    }

    public void setBlackooSquares(List<Square> blackooSquares) {
        this.blackooSquares = blackooSquares;
    }

    public List<Square> getBlackoooSquares() {
        return this.blackoooSquares;
    }

    public void setBlackoooSquares(List<Square> blackoooSquares) {
        this.blackoooSquares = blackoooSquares;
    }

    public long getWhiteooSquaresBb() {
        return this.whiteooSquaresBb;
    }

    public void setWhiteooSquaresBb(long whiteooSquaresBb) {
        this.whiteooSquaresBb = whiteooSquaresBb;
    }

    public long getWhiteoooSquaresBb() {
        return this.whiteoooSquaresBb;
    }

    public void setWhiteoooSquaresBb(long whiteoooSquaresBb) {
        this.whiteoooSquaresBb = whiteoooSquaresBb;
    }

    public long getBlackooSquaresBb() {
        return this.blackooSquaresBb;
    }

    public void setBlackooSquaresBb(long blackooSquaresBb) {
        this.blackooSquaresBb = blackooSquaresBb;
    }

    public long getBlackoooSquaresBb() {
        return this.blackoooSquaresBb;
    }

    public void setBlackoooSquaresBb(long blackoooSquaresBb) {
        this.blackoooSquaresBb = blackoooSquaresBb;
    }

    public long getWhiteooAllSquaresBb() {
        return this.whiteooAllSquaresBb;
    }

    public BoardContext setWhiteooAllSquaresBb(long whiteooAllSquaresBb) {
        this.whiteooAllSquaresBb = whiteooAllSquaresBb;
        return this;
    }

    public long getWhiteoooAllSquaresBb() {
        return this.whiteoooAllSquaresBb;
    }

    public BoardContext setWhiteoooAllSquaresBb(long whiteoooAllSquaresBb) {
        this.whiteoooAllSquaresBb = whiteoooAllSquaresBb;
        return this;
    }

    public long getBlackooAllSquaresBb() {
        return this.blackooAllSquaresBb;
    }

    public BoardContext setBlackooAllSquaresBb(long blackooAllSquaresBb) {
        this.blackooAllSquaresBb = blackooAllSquaresBb;
        return this;
    }

    public long getBlackoooAllSquaresBb() {
        return this.blackoooAllSquaresBb;
    }

    public BoardContext setBlackoooAllSquaresBb(long blackoooAllSquaresBb) {
        this.blackoooAllSquaresBb = blackoooAllSquaresBb;
        return this;
    }

    public Move getoo(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteoo() : this.getBlackoo();
    }

    public Move getooo(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteooo() : this.getBlackooo();
    }

    public Move getRookoo(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteRookoo() : this.getBlackRookoo();
    }

    public Move getRookooo(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteRookooo() : this.getBlackRookooo();
    }

    public List<Square> getooSquares(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteooSquares() : this.getBlackooSquares();
    }

    public List<Square> getoooSquares(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteoooSquares() : this.getBlackoooSquares();
    }

    public long getooSquaresBb(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteooSquaresBb() : this.getBlackooSquaresBb();
    }

    public long getoooSquaresBb(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteoooSquaresBb() : this.getBlackoooSquaresBb();
    }

    public long getooAllSquaresBb(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteooAllSquaresBb() : this.getBlackooAllSquaresBb();
    }

    public long getoooAllSquaresBb(Side side) {
        return Side.WHITE.equals((Object)side) ? this.getWhiteoooAllSquaresBb() : this.getBlackoooAllSquaresBb();
    }
}

