/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess;

import java.util.HashMap;
import java.util.Map;

public enum PieceType {
    PAWN(""),
    KNIGHT("N"),
    BISHOP("B"),
    ROOK("R"),
    QUEEN("Q"),
    KING("K"),
    NONE("NONE");

    private static final Map<String, PieceType> sanToType;
    private static final PieceType[] validValues;
    private final String sanSymbol;

    private PieceType(String sanSymbol) {
        this.sanSymbol = sanSymbol;
    }

    public static PieceType fromValue(String v) {
        return PieceType.valueOf(v);
    }

    public static PieceType fromSanSymbol(String sanSymbol) {
        PieceType pieceType = sanToType.get(sanSymbol);
        if (pieceType == null) {
            throw new IllegalArgumentException(String.format("Unknown piece '%s'", sanSymbol));
        }
        return pieceType;
    }

    public String getSanSymbol() {
        return this.sanSymbol;
    }

    public String value() {
        return this.name();
    }

    public static PieceType[] validValues() {
        return validValues;
    }

    static {
        sanToType = new HashMap<String, PieceType>(7);
        validValues = new PieceType[]{PAWN, KNIGHT, BISHOP, ROOK, QUEEN, KING};
        for (PieceType type : PieceType.values()) {
            sanToType.put(type.getSanSymbol(), type);
        }
    }
}

