/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess.move;

import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.PieceType;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.Chess.Square;

public class Move {
    private final Square from;
    private final Square to;
    private final PieceType promotion;
    private int score;

    public Move(Square from, Square to) {
        this(from, to, PieceType.NONE);
    }

    public Move(Square from, Square to, PieceType promotion) {
        this.promotion = promotion;
        this.from = from;
        this.to = to;
        this.score = 0;
    }

    public Move(String move, Side side) {
        this(Square.valueOf(move.substring(0, 2).toUpperCase()), Square.valueOf(move.substring(2, 4).toUpperCase()), move.length() < 5 ? PieceType.NONE : (Side.WHITE.equals((Object)side) ? Piece.fromFenSymbol(move.substring(4, 5).toUpperCase()).getPieceType() : Piece.fromFenSymbol(move.substring(4, 5).toLowerCase()).getPieceType()));
    }

    public Square getFrom() {
        return this.from;
    }

    public Square getTo() {
        return this.to;
    }

    public PieceType getPromotion() {
        return this.promotion;
    }

    public boolean isPromotion() {
        return !PieceType.NONE.equals((Object)this.getPromotion());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Move)) {
            return false;
        }
        Move move = (Move)obj;
        return move.getFrom().equals((Object)this.getFrom()) && move.getTo().equals((Object)this.getTo()) && move.getPromotion().equals((Object)this.getPromotion());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String promo = "";
        if (!PieceType.NONE.equals((Object)this.promotion)) {
            promo = this.promotion.getSanSymbol().toLowerCase();
        }
        return this.from.toString().toLowerCase() + this.to.toString().toLowerCase() + promo.toLowerCase();
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int asBytes() {
        int promotionBits = this.isPromotion() ? 8 | this.promotion.ordinal() - 1 : 0;
        return promotionBits << 12 | this.getFrom().ordinal() << 6 | this.getTo().ordinal();
    }

    public static Move fromBytes(int bytes) {
        PieceType promotion = PieceType.NONE;
        if (bytes >> 12 != 0) {
            promotion = PieceType.values()[(bytes >> 12 & 7) + 1];
        }
        return new Move(Square.squareAt((bytes & 0xFC0) >> 6), Square.squareAt(bytes & 0x3F), promotion);
    }
}

