/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Chess.move;

import java.util.List;
import org.shawn.games.Serendipity.Chess.Attacks;
import org.shawn.games.Serendipity.Chess.Bitboard;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.CastleRight;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.PieceType;
import org.shawn.games.Serendipity.Chess.Rank;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Chess.move.MoveGeneratorException;

public class MoveGenerator {
    private MoveGenerator() {
    }

    public static void generatePawnCaptures(Board board, List<Move> moves) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.PAWN));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getPawnCaptures(side, sqSource.getBitboard(), board.getBitboard(), board.getEnPassantTarget()) & (board.getBitboard(side) ^ 0xFFFFFFFFFFFFFFFFL);
            while (attacks != 0L) {
                int targetIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(targetIndex);
                MoveGenerator.addPromotions(moves, side, sqTarget, sqSource);
            }
        }
    }

    public static void generatePawnMoves(Board board, List<Move> moves) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.PAWN));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getPawnMoves(side, sqSource.getBitboard(), board.getBitboard());
            while (attacks != 0L) {
                int targetIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(targetIndex);
                MoveGenerator.addPromotions(moves, side, sqTarget, sqSource);
            }
        }
    }

    private static void addPromotions(List<Move> moves, Side side, Square sqTarget, Square sqSource) {
        if (Side.WHITE.equals((Object)side) && Rank.RANK_8.equals((Object)sqTarget.getRank()) || Side.BLACK.equals((Object)side) && Rank.RANK_1.equals((Object)sqTarget.getRank())) {
            moves.add(new Move(sqSource, sqTarget, PieceType.QUEEN));
            moves.add(new Move(sqSource, sqTarget, PieceType.ROOK));
            moves.add(new Move(sqSource, sqTarget, PieceType.BISHOP));
            moves.add(new Move(sqSource, sqTarget, PieceType.KNIGHT));
        } else {
            moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
        }
    }

    public static void generateKnightMoves(Board board, List<Move> moves, long mask) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.KNIGHT));
        while (pieces != 0L) {
            int knightIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(knightIndex);
            long attacks = Attacks.getKnightAttacks(sqSource, mask);
            while (attacks != 0L) {
                int attackIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(attackIndex);
                moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
            }
        }
    }

    public static void generateKnightMoves(Board board, List<Move> moves) {
        MoveGenerator.generateKnightMoves(board, moves, board.getBitboard(board.getSideToMove()) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void generateBishopMoves(Board board, List<Move> moves, long mask) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.BISHOP));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getBishopAttacks(board.getBitboard(), sqSource) & mask;
            while (attacks != 0L) {
                int attackIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(attackIndex);
                moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
            }
        }
    }

    public static void generateBishopMoves(Board board, List<Move> moves) {
        MoveGenerator.generateBishopMoves(board, moves, board.getBitboard(board.getSideToMove()) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void generateRookMoves(Board board, List<Move> moves, long mask) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.ROOK));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getRookAttacks(board.getBitboard(), sqSource) & mask;
            while (attacks != 0L) {
                int attackIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(attackIndex);
                moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
            }
        }
    }

    public static void generateRookMoves(Board board, List<Move> moves) {
        MoveGenerator.generateRookMoves(board, moves, board.getBitboard(board.getSideToMove()) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void generateQueenMoves(Board board, List<Move> moves, long mask) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.QUEEN));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getQueenAttacks(board.getBitboard(), sqSource) & mask;
            while (attacks != 0L) {
                int attackIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(attackIndex);
                moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
            }
        }
    }

    public static void generateQueenMoves(Board board, List<Move> moves) {
        MoveGenerator.generateQueenMoves(board, moves, board.getBitboard(board.getSideToMove()) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void generateKingMoves(Board board, List<Move> moves, long mask) {
        Side side = board.getSideToMove();
        long pieces = board.getBitboard(Piece.make(side, PieceType.KING));
        while (pieces != 0L) {
            int sourceIndex = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            Square sqSource = Square.squareAt(sourceIndex);
            long attacks = Attacks.getKingAttacks(sqSource, mask);
            while (attacks != 0L) {
                int attackIndex = Bitboard.bitScanForward(attacks);
                attacks = Bitboard.extractLsb(attacks);
                Square sqTarget = Square.squareAt(attackIndex);
                moves.add(new Move(sqSource, sqTarget, PieceType.NONE));
            }
        }
    }

    public static void generateKingMoves(Board board, List<Move> moves) {
        MoveGenerator.generateKingMoves(board, moves, board.getBitboard(board.getSideToMove()) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void generateCastleMoves(Board board, List<Move> moves) {
        Side side = board.getSideToMove();
        if (board.isKingAttacked()) {
            return;
        }
        if ((board.getCastleRight(side).equals((Object)CastleRight.KING_AND_QUEEN_SIDE) || board.getCastleRight(side).equals((Object)CastleRight.KING_SIDE)) && (board.getBitboard() & board.getContext().getooAllSquaresBb(side)) == 0L && !board.isSquareAttackedBy(board.getContext().getooSquares(side), side.flip())) {
            moves.add(board.getContext().getoo(side));
        }
        if ((board.getCastleRight(side).equals((Object)CastleRight.KING_AND_QUEEN_SIDE) || board.getCastleRight(side).equals((Object)CastleRight.QUEEN_SIDE)) && (board.getBitboard() & board.getContext().getoooAllSquaresBb(side)) == 0L && !board.isSquareAttackedBy(board.getContext().getoooSquares(side), side.flip())) {
            moves.add(board.getContext().getooo(side));
        }
    }

    public static void generatePseudoLegalMoves(Board board, List<Move> moves) {
        MoveGenerator.generatePawnCaptures(board, moves);
        MoveGenerator.generatePawnMoves(board, moves);
        MoveGenerator.generateKnightMoves(board, moves);
        MoveGenerator.generateBishopMoves(board, moves);
        MoveGenerator.generateRookMoves(board, moves);
        MoveGenerator.generateQueenMoves(board, moves);
        MoveGenerator.generateKingMoves(board, moves);
        MoveGenerator.generateCastleMoves(board, moves);
    }

    public static void generatePseudoLegalCaptures(Board board, List<Move> moves) {
        Side other = board.getSideToMove().flip();
        MoveGenerator.generatePawnCaptures(board, moves);
        MoveGenerator.generateKnightMoves(board, moves, board.getBitboard(other));
        MoveGenerator.generateBishopMoves(board, moves, board.getBitboard(other));
        MoveGenerator.generateRookMoves(board, moves, board.getBitboard(other));
        MoveGenerator.generateQueenMoves(board, moves, board.getBitboard(other));
        MoveGenerator.generateKingMoves(board, moves, board.getBitboard(other));
    }

    public static void generateLegalMoves(Board board, List<Move> moves) throws MoveGeneratorException {
        try {
            MoveGenerator.generatePseudoLegalMoves(board, moves);
            moves.removeIf(move -> !board.isMoveLegal((Move)move, false));
        }
        catch (Exception e) {
            throw new MoveGeneratorException("Couldn't generate Legal moves: ", e);
        }
    }
}

