/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.NNUE;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.PieceType;
import org.shawn.games.Serendipity.Chess.Side;
import org.shawn.games.Serendipity.NNUE.NNUE;

public class AccumulatorCache {
    private final Entry[][] entries = new Entry[Side.values().length][7];

    public AccumulatorCache(NNUE network) {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                this.entries[i][j] = new Entry();
            }
        }
        this.clear(network);
    }

    public void clear(NNUE network) {
        Entry[][] entryArray = this.entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry[] row;
            for (Entry entry : row = entryArray[i]) {
                assert (entry.storedAccumulator.length == 1536);
                System.arraycopy(network.L1Biases, 0, entry.storedAccumulator, 0, 1536);
                Arrays.fill(entry.bySide, 0L);
                Arrays.fill(entry.byPieceType, 0L);
            }
        }
    }

    public Entry get(Side side, int kingBucket) {
        return this.entries[side.ordinal()][kingBucket];
    }

    public class Entry {
        public final short[] storedAccumulator = new short[1536];
        private final long[] bySide = new long[Side.values().length];
        private final long[] byPieceType = new long[PieceType.validValues().length];

        public long getBitboard(Side side, PieceType pieceType) {
            return this.bySide[side.ordinal()] & this.byPieceType[pieceType.ordinal()];
        }

        public void update(Board board) {
            for (Side side : Side.values()) {
                this.bySide[side.ordinal()] = board.getBitboard(side);
            }
            for (Enum enum_ : PieceType.validValues()) {
                this.byPieceType[enum_.ordinal()] = board.getBitboard((PieceType)enum_);
            }
        }
    }
}

