/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import org.shawn.games.Serendipity.Chess.AccumulatorDiff;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Constants;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.NNUE.AccumulatorStack;
import org.shawn.games.Serendipity.NNUE.NNUE;
import org.shawn.games.Serendipity.Search.History.History;
import org.shawn.games.Serendipity.Search.Limits;
import org.shawn.games.Serendipity.Search.Listener.FinalReport;
import org.shawn.games.Serendipity.Search.Listener.ISearchListener;
import org.shawn.games.Serendipity.Search.Listener.SearchReport;
import org.shawn.games.Serendipity.Search.MovePicker;
import org.shawn.games.Serendipity.Search.SearchStack;
import org.shawn.games.Serendipity.Search.SharedThreadData;
import org.shawn.games.Serendipity.Search.ThreadData;
import org.shawn.games.Serendipity.Search.TimeManager;
import org.shawn.games.Serendipity.Search.TimeOutException;
import org.shawn.games.Serendipity.Search.TranspositionTable;

public class AlphaBeta
implements Runnable {
    public static final int VALUE_NONE = 30002;
    public static final int MAX_EVAL = Short.MAX_VALUE;
    public static final int MIN_EVAL = -32767;
    public static final int MATE_EVAL = 32700;
    public static final int DRAW_EVAL = 0;
    public static final int MAX_PLY = 245;
    public static final int MATE_IN_MAX_PLY = 32455;
    public final int[][] reduction = new int[246][246];
    private int nmpMinPly;
    private AccumulatorStack accumulators;
    private final ThreadData threadData;
    private final SharedThreadData sharedThreadData;
    private SearchStack ss = new SearchStack(245);
    private TimeManager timeManager;
    private Board internalBoard;
    private Move bestMove;

    public AlphaBeta(SharedThreadData sharedThreadData, ThreadData threadData) {
        this.sharedThreadData = sharedThreadData;
        this.threadData = threadData;
        if (threadData.id == 0) {
            this.timeManager = new TimeManager();
        }
        for (int i = 0; i < this.reduction.length; ++i) {
            for (int j = 0; j < this.reduction[0].length; ++j) {
                this.reduction[i][j] = (int)(1.6 + Math.log(i) * Math.log(j) / 2.17);
            }
        }
    }

    private void updatePV(Move move, int ply) {
        this.threadData.pv[ply][0] = move;
        System.arraycopy(this.threadData.pv[ply + 1], 0, this.threadData.pv[ply], 1, 245);
    }

    private void clearPV() {
        this.threadData.pv = new Move[246][246];
    }

    private static int stat_bonus(int depth) {
        return depth * 300 - 300;
    }

    private static int stat_malus(int depth) {
        return -AlphaBeta.stat_bonus(depth);
    }

    private boolean shouldStop() {
        return this.threadData.id == 0 && this.threadData.mainThreadData.limits.getNodes() > 0L && this.threadData.nodes.get() > this.threadData.mainThreadData.limits.getNodes() || this.sharedThreadData.stopped.get() || this.threadData.id == 0 && this.timeManager.shouldStop();
    }

    public int evaluate(Board board) {
        int v = NNUE.evaluate(board, this.sharedThreadData.network, this.accumulators);
        int material = Long.bitCount(board.getBitboard(Piece.WHITE_BISHOP) | board.getBitboard(Piece.BLACK_BISHOP)) * 3 + Long.bitCount(board.getBitboard(Piece.WHITE_KNIGHT) | board.getBitboard(Piece.BLACK_KNIGHT)) * 3 + Long.bitCount(board.getBitboard(Piece.WHITE_ROOK) | board.getBitboard(Piece.BLACK_ROOK)) * 5 + Long.bitCount(board.getBitboard(Piece.WHITE_QUEEN) | board.getBitboard(Piece.BLACK_QUEEN)) * 10;
        v = v * (206 + material) / 256;
        v = Math.min(Math.max(-32455, v), 32455);
        return v;
    }

    private void updateContinuationHistories(int ply, int depth, Board board, Move move, List<Move> quietsSearched) {
        int bonus = AlphaBeta.stat_bonus(depth);
        int malus = AlphaBeta.stat_malus(depth);
        for (int i : new int[]{1, 2, 4, 6}) {
            History conthist = this.ss.get((int)(ply - i)).continuationHistory;
            conthist.register(board, move, i == 6 ? bonus / 2 : bonus);
            for (Move quietMove : quietsSearched) {
                conthist.register(board, quietMove, i == 6 ? malus / 2 : malus);
            }
        }
    }

    private int quiesce(Board board, int alpha, int beta, int ply) throws TimeOutException {
        Move move;
        MovePicker movePicker;
        int bestScore;
        int futilityBase;
        Move ttMove;
        this.threadData.nodes.incrementAndGet();
        this.threadData.selDepth = Math.max(this.threadData.selDepth, ply);
        SearchStack.SearchState sse = this.ss.get(ply);
        if (board.isRepetition() || board.getHalfMoveCounter() > 100) {
            return 0;
        }
        if ((this.threadData.nodes.get() & 0x3FFL) == 0L && this.shouldStop()) {
            if (this.threadData.id == 0) {
                this.sharedThreadData.stopped.set(true);
            }
            throw new TimeOutException();
        }
        boolean isPV = beta - alpha > 1;
        int oldAlpha = alpha;
        TranspositionTable.Entry currentMoveEntry = this.sharedThreadData.tt.probe(board.getIncrementalHashKey());
        boolean ttHit = currentMoveEntry.hit() && currentMoveEntry.verifySignature(board.getIncrementalHashKey());
        Move move2 = ttMove = ttHit ? currentMoveEntry.getMove() : null;
        if (!isPV && ttHit && currentMoveEntry.getNodeType() != 0) {
            int eval = currentMoveEntry.getEvaluation();
            switch (currentMoveEntry.getNodeType()) {
                case 3: {
                    return eval;
                }
                case 2: {
                    if (eval > alpha) break;
                    return eval;
                }
                case 1: {
                    if (eval < beta) break;
                    return eval;
                }
                default: {
                    ttHit = false;
                }
            }
        }
        if (ply >= 245) {
            return this.evaluate(board);
        }
        sse.inCheck = board.isKingAttacked();
        boolean inCheck = sse.inCheck;
        if (inCheck) {
            futilityBase = -32767;
            bestScore = -32767;
            History[] currentContinuationHistories = new History[]{this.ss.get((int)(ply - 1)).continuationHistory, this.ss.get((int)(ply - 2)).continuationHistory, null, this.ss.get((int)(ply - 4)).continuationHistory, null, this.ss.get((int)(ply - 6)).continuationHistory};
            movePicker = new MovePicker(board, ttMove, null, this.threadData.history, this.threadData.captureHistory, currentContinuationHistories);
        } else {
            if (ttHit) {
                bestScore = sse.staticEval = currentMoveEntry.getStaticEval();
            } else {
                bestScore = sse.staticEval = this.evaluate(board);
                this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 0, -3, 30002, null, sse.staticEval);
            }
            alpha = Math.max(alpha, sse.staticEval);
            if (alpha >= beta) {
                return alpha;
            }
            futilityBase = sse.staticEval + 205;
            movePicker = new MovePicker(board, ttMove, this.threadData.captureHistory);
        }
        while ((move = movePicker.next()) != null) {
            if (!board.isMoveLegal(move, false)) continue;
            if (bestScore > -32455 && futilityBase < alpha && !board.staticExchangeEvaluation(move, 1) && board.hasNonPawnMaterial()) {
                bestScore = Math.max(bestScore, futilityBase);
                continue;
            }
            if (!inCheck && !board.staticExchangeEvaluation(move, -20)) continue;
            AccumulatorDiff diff = board.doMove(move);
            this.accumulators.push(board, move, diff);
            sse.move = move;
            sse.continuationHistory = this.threadData.continuationHistories.get(board, sse.move);
            int score = -this.quiesce(board, -beta, -alpha, ply + 1);
            board.undoMove();
            this.accumulators.pop();
            if ((alpha = Math.max(alpha, bestScore = Math.max(bestScore, score))) < beta) continue;
            break;
        }
        if (bestScore == -32767 && inCheck) {
            return -32700 + ply;
        }
        if (alpha >= oldAlpha) {
            this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 1, -1, bestScore, this.bestMove, sse.staticEval);
        } else {
            this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 2, -1, bestScore, ttMove, sse.staticEval);
        }
        return bestScore;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int mainSearch(Board board, int depth, int alpha, int beta, int ply, boolean cutNode) throws TimeOutException {
        Move move;
        int razorValue;
        boolean ttCapture;
        int eval;
        TranspositionTable.Entry currentMoveEntry;
        boolean inSingularSearch;
        this.threadData.nodes.incrementAndGet();
        this.ss.get((int)(ply + 2)).killer = null;
        this.threadData.selDepth = Math.max(this.threadData.selDepth, ply);
        SearchStack.SearchState sse = this.ss.get(ply);
        int bestValue = -32767;
        Move bestMove = null;
        sse.moveCount = 0;
        boolean isPV = beta - alpha > 1;
        boolean inCheck = sse.inCheck = board.isKingAttacked();
        boolean bl = inSingularSearch = sse.excludedMove != null;
        if (isPV) {
            this.threadData.pv[ply][0] = null;
        }
        if ((this.threadData.nodes.get() & 0x3FFL) == 0L && this.shouldStop()) {
            if (this.threadData.id != 0) throw new TimeOutException();
            this.sharedThreadData.stopped.set(true);
            throw new TimeOutException();
        }
        if (ply > 0) {
            if (board.isRepetition(2)) return 0;
            if (board.getHalfMoveCounter() > 100) return 0;
            if (board.isInsufficientMaterial()) {
                return 0;
            }
        }
        if (ply > 0 && (alpha = Math.max(alpha, -32700 + ply)) >= (beta = Math.min(beta, 32700 - ply - 1))) {
            return alpha;
        }
        if (depth <= 0 || ply >= 245) {
            this.threadData.nodes.decrementAndGet();
            return this.quiesce(board, alpha, beta, ply);
        }
        if (depth >= 245) {
            depth = 244;
        }
        boolean bl2 = sse.ttHit = (currentMoveEntry = this.sharedThreadData.tt.probe(board.getIncrementalHashKey())).hit() && currentMoveEntry.verifySignature(board.getIncrementalHashKey());
        if (!inSingularSearch && !isPV && sse.ttHit && currentMoveEntry.getDepth() >= depth) {
            eval = currentMoveEntry.getEvaluation();
            switch (currentMoveEntry.getNodeType()) {
                case 3: {
                    return eval;
                }
                case 2: {
                    if (eval > alpha) break;
                    return eval;
                }
                case 1: {
                    if (eval < beta) break;
                    return eval;
                }
                default: {
                    sse.ttHit = false;
                }
            }
        }
        Move ttMove = sse.ttHit ? currentMoveEntry.getMove() : null;
        boolean bl3 = ttCapture = ttMove != null && !board.isQuiet(ttMove);
        if (inCheck) {
            sse.staticEval = 30002;
            eval = 30002;
        } else if (sse.ttHit) {
            eval = sse.staticEval = currentMoveEntry.getStaticEval();
            if (currentMoveEntry.getEvaluation() != 30002) {
                eval = currentMoveEntry.getEvaluation();
                switch (currentMoveEntry.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        if (eval <= sse.staticEval) break;
                        eval = sse.staticEval;
                        break;
                    }
                    case 1: {
                        if (eval >= sse.staticEval) break;
                        eval = sse.staticEval;
                        break;
                    }
                    default: {
                        sse.ttHit = false;
                        break;
                    }
                }
            }
        } else {
            eval = sse.staticEval = this.evaluate(board);
            this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 0, -3, 30002, null, sse.staticEval);
        }
        boolean improving = false;
        if (!inCheck) {
            improving = this.ss.get((int)(ply - 2)).staticEval != 30002 ? this.ss.get((int)(ply - 2)).staticEval < sse.staticEval : (this.ss.get((int)(ply - 4)).staticEval != 30002 ? this.ss.get((int)(ply - 4)).staticEval < sse.staticEval : true);
        }
        if (!(inSingularSearch || isPV || inCheck || ttMove != null && !ttCapture || depth >= 7 || eval < beta || eval - depth * 70 + (improving ? 70 : 0) < beta)) {
            int n;
            if (beta > -32455) {
                n = beta + (eval - beta) / 3;
                return n;
            }
            n = eval;
            return n;
        }
        if (!(inSingularSearch || !cutNode || ply <= 0 || eval < beta || beta >= 32455 || inCheck || this.ss.get((int)(ply - 1)).move != null && this.ss.get((int)(ply - 1)).move.equals(Constants.emptyMove) || !board.hasNonPawnMaterial())) {
            int r = depth / 3 + 4 + Math.min((eval - beta) / 200, 3);
            board.doNullMove();
            sse.move = Constants.emptyMove;
            sse.continuationHistory = this.threadData.continuationHistories.get(board, sse.move);
            int nullEval = -this.mainSearch(board, depth - r, -beta, -beta + 1, ply + 1, !cutNode);
            board.undoMove();
            if (nullEval >= beta && nullEval < 32455) {
                if (this.nmpMinPly != 0) return nullEval;
                if (depth < 12) {
                    return nullEval;
                }
                this.nmpMinPly = ply + 3 * (depth - r) / 4;
                int v = this.mainSearch(board, depth - r, -beta, -beta + 1, ply, false);
                this.nmpMinPly = 0;
                if (v >= beta) {
                    return nullEval;
                }
            }
        }
        if (!inCheck && depth <= 5 && eval + 256 * depth < alpha && (razorValue = this.quiesce(board, alpha, alpha + 1, ply)) <= alpha) {
            return razorValue;
        }
        int oldAlpha = alpha;
        History[] currentContinuationHistories = new History[]{this.ss.get((int)(ply - 1)).continuationHistory, this.ss.get((int)(ply - 2)).continuationHistory, null, this.ss.get((int)(ply - 4)).continuationHistory, null, this.ss.get((int)(ply - 6)).continuationHistory};
        ArrayList<Move> quietsSearched = new ArrayList<Move>();
        ArrayList<Move> capturesSearched = new ArrayList<Move>();
        if (isPV && ttMove == null && this.threadData.rootDepth > 1 && depth > 5) {
            depth -= 2;
        }
        MovePicker movePicker = new MovePicker(board, ttMove, sse.killer, this.threadData.history, this.threadData.captureHistory, currentContinuationHistories);
        while ((move = movePicker.next()) != null) {
            if (move.equals(sse.excludedMove) || !board.isMoveLegal(move, false)) continue;
            ++sse.moveCount;
            boolean isQuiet = board.isQuiet(move);
            boolean givesCheck = board.attacksKing(move);
            int r = this.reduction[depth][sse.moveCount];
            int newdepth = depth - 1;
            int lmrDepth = depth - r;
            if (isQuiet && !isPV && !givesCheck && sse.moveCount > 3 + depth * depth / (improving ? 1 : 2) && alpha > -32455 || bestValue > -32455 && ply > 0 && board.hasNonPawnMaterial() && (!inCheck && !givesCheck && isQuiet && lmrDepth <= 8 && sse.staticEval + lmrDepth * 150 + 150 <= alpha || depth < 9 && !board.staticExchangeEvaluation(move, isQuiet && !givesCheck ? -65 * depth : -38 * depth * depth))) continue;
            int extension = 0;
            if (!inSingularSearch && ply > 0 && sse.ttHit && move.equals(ttMove) && depth >= 4 && Math.abs(currentMoveEntry.getEvaluation()) < 32455 && (currentMoveEntry.getNodeType() == 3 || currentMoveEntry.getNodeType() == 1) && currentMoveEntry.getDepth() > depth - 4) {
                int singularBeta = currentMoveEntry.getEvaluation() - 2 * depth;
                int singularDepth = depth / 2;
                int moveCountBackup = sse.moveCount;
                sse.excludedMove = move;
                int singularValue = this.mainSearch(board, singularDepth, singularBeta - 1, singularBeta, ply, cutNode);
                sse.excludedMove = null;
                sse.moveCount = moveCountBackup;
                if (singularValue < singularBeta) {
                    extension = 1;
                    if (!isPV && !ttMove.isPromotion()) {
                        extension = 2;
                    }
                } else if (singularValue >= beta) {
                    return singularValue;
                }
            }
            newdepth += extension;
            if (isQuiet) {
                history = this.threadData.history.get(board, move) * 2 + currentContinuationHistories[0].get(board, move) + currentContinuationHistories[1].get(board, move) + currentContinuationHistories[3].get(board, move) + 6628;
                r -= history / 10000;
            } else {
                history = this.threadData.captureHistory.get(board, move) - 6284;
                r -= history / 9000;
            }
            AccumulatorDiff diff = board.doMove(move);
            this.accumulators.push(board, move, diff);
            sse.move = move;
            sse.continuationHistory = this.threadData.continuationHistories.get(board, sse.move);
            int thisMoveEval = -32767;
            if (sse.moveCount > 1 + (ply == 0 ? 1 : 0) && depth > 2) {
                r -= isPV ? 1 : 0;
                r -= givesCheck ? 1 : 0;
                r -= !isQuiet ? 1 : 0;
                int d = Math.min(newdepth, newdepth - (r += cutNode ? 1 : 0));
                thisMoveEval = -this.mainSearch(board, d, -(alpha + 1), -alpha, ply + 1, true);
                if (thisMoveEval > alpha) {
                    thisMoveEval = -this.mainSearch(board, newdepth, -(alpha + 1), -alpha, ply + 1, !cutNode);
                }
            } else if (!isPV || sse.moveCount > 1) {
                thisMoveEval = -this.mainSearch(board, newdepth, -(alpha + 1), -alpha, ply + 1, !cutNode);
            }
            if (isPV && (sse.moveCount == 1 || thisMoveEval > alpha)) {
                thisMoveEval = -this.mainSearch(board, newdepth, -beta, -alpha, ply + 1, false);
            }
            board.undoMove();
            this.accumulators.pop();
            if (thisMoveEval > bestValue) {
                bestValue = thisMoveEval;
                bestMove = move;
                if (isPV) {
                    this.updatePV(move, ply);
                }
            }
            if (thisMoveEval > alpha) {
                alpha = thisMoveEval;
                if (ply == 0) {
                    this.bestMove = move;
                }
                if (alpha >= beta) {
                    if (isQuiet) {
                        sse.killer = move;
                        this.threadData.history.register(board, move, AlphaBeta.stat_bonus(depth));
                        for (Move quietMove : quietsSearched) {
                            this.threadData.history.register(board, quietMove, AlphaBeta.stat_malus(depth));
                        }
                        this.updateContinuationHistories(ply, depth, board, move, quietsSearched);
                        break;
                    }
                    this.threadData.captureHistory.register(board, move, AlphaBeta.stat_bonus(depth));
                    for (Move capture : capturesSearched) {
                        this.threadData.captureHistory.register(board, capture, AlphaBeta.stat_malus(depth));
                    }
                    break;
                }
            }
            if (isQuiet) {
                quietsSearched.add(move);
                continue;
            }
            capturesSearched.add(move);
        }
        if (sse.moveCount == 0) {
            if (inSingularSearch) {
                return alpha;
            }
            if (!inCheck) return 0;
            return -32700 + ply;
        }
        if (inSingularSearch) return bestValue;
        if (alpha >= beta) {
            this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 1, depth, bestValue, bestMove, sse.staticEval);
            return bestValue;
        }
        if (alpha == oldAlpha) {
            this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 2, depth, bestValue, ttMove, sse.staticEval);
            return bestValue;
        }
        if (alpha <= oldAlpha) return bestValue;
        this.sharedThreadData.tt.write(currentMoveEntry, board.getIncrementalHashKey(), 3, depth, bestValue, bestMove, sse.staticEval);
        return bestValue;
    }

    public void iterativeDeepening(boolean suppressOutput) {
        int currentScore = -32767;
        Move[] lastCompletePV = null;
        int alpha = -32767;
        int beta = Short.MAX_VALUE;
        int delta = 30002;
        try {
            block2: for (int i = 1; i < 245 && (this.threadData.id != 0 || i <= this.threadData.mainThreadData.limits.getDepth() && !this.timeManager.shouldStopIterativeDeepening()); ++i) {
                this.threadData.rootDepth = i;
                this.threadData.selDepth = 0;
                this.bestMove = null;
                if (i > 3) {
                    delta = 25;
                    alpha = Math.max(currentScore - delta, -32767);
                    beta = Math.min(currentScore + delta, Short.MAX_VALUE);
                }
                while (true) {
                    int newScore;
                    if ((newScore = this.mainSearch(this.internalBoard, i, alpha, beta, 0, false)) > alpha && newScore < beta) {
                        currentScore = newScore;
                        lastCompletePV = (Move[])this.threadData.pv[0].clone();
                        if (suppressOutput || this.threadData.id != 0) continue block2;
                        long totalNodes = 0L;
                        for (AlphaBeta thread : this.threadData.mainThreadData.threads) {
                            totalNodes += thread.getNodesCount();
                        }
                        SearchReport report = new SearchReport(i, this.threadData.selDepth, totalNodes, this.sharedThreadData.tt.hashfull(), currentScore, this.timeManager.timePassed(), this.internalBoard, lastCompletePV);
                        for (ISearchListener listener : this.threadData.mainThreadData.listeners) {
                            listener.notify(report);
                        }
                        continue block2;
                    }
                    if (newScore <= alpha) {
                        beta = (alpha + beta) / 2;
                        alpha = Math.max(alpha - delta, -32767);
                    } else {
                        beta = Math.min(beta + delta, Short.MAX_VALUE);
                    }
                    delta += delta * 3;
                }
            }
        }
        catch (TimeOutException i) {
            // empty catch block
        }
        if (this.threadData.id == 0) {
            this.sharedThreadData.stopped.set(true);
        }
        if (!suppressOutput && this.threadData.id == 0) {
            Object reportedBestMove = this.bestMove;
            if (reportedBestMove == null) {
                reportedBestMove = lastCompletePV == null ? this.getEmergencyBestMove() : lastCompletePV[0];
            }
            FinalReport report = new FinalReport((Move)reportedBestMove);
            for (ISearchListener listener : this.threadData.mainThreadData.listeners) {
                listener.notify(report);
            }
        }
    }

    private Move getEmergencyBestMove() {
        return this.internalBoard.legalMoves().get(0);
    }

    public long getNodesCount() {
        return this.threadData.nodes.get();
    }

    public void reset() {
        this.ss = new SearchStack(245);
        this.threadData.nodes.set(0L);
        this.threadData.rootDepth = 0;
        this.threadData.selDepth = 0;
        this.threadData.history.fill(0);
        this.threadData.captureHistory.fill(0);
        this.threadData.continuationHistories.fill(0);
        this.threadData.pv = new Move[246][246];
        for (int i = 0; i < this.reduction.length; ++i) {
            for (int j = 0; j < this.reduction[0].length; ++j) {
                this.reduction[i][j] = (int)(1.6 + Math.log(i) * Math.log(j) / 2.17);
            }
        }
    }

    public void setBoard(Board board) {
        this.internalBoard = board.clone();
    }

    public void updateTM(Limits limits) {
        this.threadData.mainThreadData.limits = limits.clone();
        this.timeManager.set(limits);
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.sharedThreadData.endBarrier.await();
                this.sharedThreadData.startBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                break;
            }
            this.prepareThreadAndDoIterativeDeepening();
        }
    }

    public void prepareThreadAndDoIterativeDeepening() {
        this.nmpMinPly = 0;
        this.threadData.nodes.set(0L);
        this.ss = new SearchStack(245);
        this.sharedThreadData.stopped.set(false);
        this.accumulators = new AccumulatorStack(this.sharedThreadData.network);
        this.accumulators.init(this.internalBoard);
        this.bestMove = null;
        this.clearPV();
        this.iterativeDeepening(false);
    }
}

