/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search.History;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.PieceType;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.History.History;

public class CaptureHistory
implements History {
    private final int[][][] history = new int[Piece.values().length][Square.values().length][PieceType.values().length];
    static final int MAX_BONUS = 16384;

    public int get(Piece piece, Square to, PieceType captured) {
        return this.history[piece.ordinal()][to.ordinal()][captured.ordinal()];
    }

    private static int clamp(int v) {
        return v >= 16384 ? 16384 : Math.max(v, -16384);
    }

    public void register(Piece piece, Square to, PieceType captured, int value) {
        int clampedValue = CaptureHistory.clamp(value);
        if (captured == null) {
            captured = PieceType.NONE;
        }
        int[] nArray = this.history[piece.ordinal()][to.ordinal()];
        int n = captured.ordinal();
        nArray[n] = nArray[n] + (clampedValue - this.history[piece.ordinal()][to.ordinal()][captured.ordinal()] * Math.abs(clampedValue) / 16384);
    }

    @Override
    public int get(Board board, Move move) {
        Piece movedPiece = board.getPiece(move.getFrom());
        if (move.getTo().equals((Object)board.getEnPassant()) && movedPiece.getPieceType().equals((Object)PieceType.PAWN)) {
            return this.get(movedPiece, board.getEnPassant(), PieceType.PAWN);
        }
        if (Piece.NONE.equals((Object)board.getPiece(move.getTo()))) {
            return this.get(movedPiece, move.getTo(), PieceType.NONE);
        }
        return this.get(movedPiece, move.getTo(), board.getPiece(move.getTo()).getPieceType());
    }

    @Override
    public void register(Board board, Move move, int value) {
        Piece movedPiece = board.getPiece(move.getFrom());
        if (move.getTo().equals((Object)board.getEnPassant()) && movedPiece.getPieceType().equals((Object)PieceType.PAWN)) {
            this.register(movedPiece, board.getEnPassant(), PieceType.PAWN, value);
            return;
        }
        this.register(movedPiece, move.getTo(), board.getPiece(move.getTo()).getPieceType(), value);
    }

    @Override
    public void fill(int x) {
        int[][][] nArray = this.history;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[][] x1;
            for (int[] x2 : x1 = nArray[i]) {
                Arrays.fill(x2, x);
            }
        }
    }
}

