/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search.History;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.History.History;
import org.shawn.games.Serendipity.Search.History.PieceToHistory;

public class ContinuationHistories {
    private final PieceToHistory[][] continuationHistories = new PieceToHistory[Piece.values().length][Square.values().length];

    public ContinuationHistories() {
        for (int i = 0; i < Piece.values().length; ++i) {
            for (int j = 0; j < Square.values().length; ++j) {
                this.continuationHistories[i][j] = new PieceToHistory();
            }
        }
    }

    public History get(Piece piece, Square to) {
        return this.continuationHistories[piece.ordinal()][to.ordinal()];
    }

    public History get(Board board, Move move) {
        return this.get(board.getPiece(move.getFrom()), move.getTo());
    }

    public void fill(int x) {
        for (PieceToHistory[] row : this.continuationHistories) {
            Arrays.stream(row).forEach(history -> history.fill(x));
        }
    }
}

