/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search.History;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.History.History;

public class FromToHistory
implements History {
    private final int[] history;
    static final int MAX_BONUS = 16384;
    final int DIMENSION = Square.values().length;

    public FromToHistory() {
        this.history = new int[this.DIMENSION * this.DIMENSION];
    }

    public int get(Square from, Square to) {
        return this.history[from.ordinal() * this.DIMENSION + to.ordinal()];
    }

    public int get(Move move) {
        return this.get(move.getFrom(), move.getTo());
    }

    private static int clamp(int v) {
        return v >= 16384 ? 16384 : Math.max(v, -16384);
    }

    public void register(Square from, Square to, int value) {
        int clampedValue = FromToHistory.clamp(value);
        int n = from.ordinal() * this.DIMENSION + to.ordinal();
        this.history[n] = this.history[n] + (clampedValue - this.history[from.ordinal() * this.DIMENSION + to.ordinal()] * Math.abs(clampedValue) / 16384);
    }

    @Override
    public int get(Board board, Move move) {
        return this.get(move.getFrom(), move.getTo());
    }

    @Override
    public void register(Board board, Move move, int value) {
        this.register(move.getFrom(), move.getTo(), value);
    }

    @Override
    public void fill(int x) {
        Arrays.fill(this.history, x);
    }
}

