/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search.History;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.Square;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.History.History;

public class PieceToHistory
implements History {
    private final int[][] history = new int[Piece.values().length][Square.values().length];
    static final int MAX_BONUS = 16384;

    public int get(Piece piece, Square to) {
        return this.history[piece.ordinal()][to.ordinal()];
    }

    public int get(Piece piece, Move move) {
        return this.get(piece, move.getTo());
    }

    private static int clamp(int v) {
        return v >= 16384 ? 16384 : Math.max(v, -16384);
    }

    public void register(Piece piece, Square to, int value) {
        int clampedValue = PieceToHistory.clamp(value);
        int[] nArray = this.history[piece.ordinal()];
        int n = to.ordinal();
        nArray[n] = nArray[n] + (clampedValue - this.history[piece.ordinal()][to.ordinal()] * Math.abs(clampedValue) / 16384);
    }

    @Override
    public int get(Board board, Move move) {
        return this.get(board.getPiece(move.getFrom()), move.getTo());
    }

    @Override
    public void register(Board board, Move move, int value) {
        this.register(board.getPiece(move.getFrom()), move.getTo(), value);
    }

    @Override
    public void fill(int x) {
        for (int[] row : this.history) {
            Arrays.fill(row, x);
        }
    }
}

