/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search;

import java.util.ArrayList;
import java.util.Collections;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Piece;
import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.History.History;

public class MovePicker {
    private Board board;
    private Move ttMove;
    private Move killer;
    private History history;
    private History captureHistory;
    private History[] continuationHistories;
    private ArrayList<Move> moves;
    private int stage;
    private int moveIndex;
    private static final int STAGE_NORMAL_TT = 0;
    private static final int STAGE_NORMAL = 1;
    private static final int STAGE_QSEARCH_TT = 2;
    private static final int STAGE_QSEARCH_CAPTURE = 3;

    public MovePicker(Board board, Move ttMove) {
        this(board, ttMove, null, null, null, null);
    }

    public MovePicker(Board board, Move ttMove, Move killer, History history, History captureHistory, History[] continuationHistories) {
        this.board = board;
        this.ttMove = ttMove;
        if (ttMove == null || !board.isMovePseudoLegal(ttMove)) {
            this.ttMove = null;
            this.stage = 1;
        } else {
            this.stage = 0;
        }
        this.killer = killer;
        this.history = history;
        this.captureHistory = captureHistory;
        this.continuationHistories = continuationHistories;
    }

    public MovePicker(Board board, Move ttMove, History captureHistory) {
        this.board = board;
        this.ttMove = ttMove;
        if (ttMove == null || !board.isMovePseudoLegal(ttMove) || !board.isCapture(ttMove)) {
            this.ttMove = null;
            this.stage = 3;
        } else {
            this.stage = 2;
        }
        this.killer = null;
        this.history = null;
        this.captureHistory = captureHistory;
        this.continuationHistories = null;
    }

    private static int pieceValue(Piece p) {
        if (p.getPieceType() == null) {
            return 0;
        }
        return p.getPieceType().ordinal() + 1;
    }

    private int captureValue(Move move) {
        return MovePicker.pieceValue(this.board.getPiece(move.getTo())) * 100 + this.captureHistory.get(this.board, move) / 256;
    }

    private int scoreMove(Move move) {
        if (!this.board.isQuiet(move)) {
            int score = this.board.staticExchangeEvaluation(move, -20) ? 900000000 : -1000000;
            return score += this.captureValue(move);
        }
        if (move.equals(this.killer)) {
            return 800000000;
        }
        int moveValue = this.history.get(this.board, move);
        moveValue += this.continuationHistories[0].get(this.board, move);
        moveValue += this.continuationHistories[1].get(this.board, move);
        moveValue += this.continuationHistories[3].get(this.board, move);
        return moveValue += this.continuationHistories[5].get(this.board, move) / 2;
    }

    public void initMoves() {
        this.moves = new ArrayList();
        this.board.generatePseudoLegalMoves(this.moves);
        for (int i = 0; i < this.moves.size(); ++i) {
            Move currentMove = this.moves.get(i);
            currentMove.setScore(this.scoreMove(currentMove));
        }
    }

    public void initCaptures() {
        this.moves = new ArrayList();
        this.board.generatePseudoLegalCaptures(this.moves);
        for (int i = 0; i < this.moves.size(); ++i) {
            Move currentMove = this.moves.get(i);
            currentMove.setScore(this.captureValue(currentMove));
        }
    }

    public Move selectMove() {
        if (this.moveIndex >= this.moves.size()) {
            return null;
        }
        int swapIndex = this.moveIndex;
        int maxScore = this.moves.get(this.moveIndex).getScore();
        for (int i = this.moveIndex + 1; i < this.moves.size(); ++i) {
            int currScore = this.moves.get(i).getScore();
            if (maxScore >= currScore) continue;
            swapIndex = i;
            maxScore = currScore;
        }
        Collections.swap(this.moves, swapIndex, this.moveIndex);
        ++this.moveIndex;
        return this.moves.get(this.moveIndex - 1);
    }

    public Move next() {
        switch (this.stage) {
            case 0: {
                ++this.stage;
                return this.ttMove;
            }
            case 1: {
                Move ret;
                if (this.moves == null) {
                    this.initMoves();
                }
                if ((ret = this.selectMove()) != null && ret.equals(this.ttMove)) {
                    ret = this.selectMove();
                }
                return ret;
            }
            case 2: {
                ++this.stage;
                return this.ttMove;
            }
            case 3: {
                Move ret;
                if (this.moves == null) {
                    this.initCaptures();
                }
                if ((ret = this.selectMove()) != null && ret.equals(this.ttMove)) {
                    ret = this.selectMove();
                }
                return ret;
            }
        }
        return null;
    }
}

