/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.NNUE.NNUE;
import org.shawn.games.Serendipity.Search.AlphaBeta;
import org.shawn.games.Serendipity.Search.Limits;
import org.shawn.games.Serendipity.Search.Listener.ISearchListener;
import org.shawn.games.Serendipity.Search.SharedThreadData;
import org.shawn.games.Serendipity.Search.ThreadData;
import org.shawn.games.Serendipity.Search.TranspositionTable;
import org.shawn.games.Serendipity.UCI.UCIListener;

public class ThreadManager {
    List<ThreadData> threadData;
    List<AlphaBeta> threads;
    int threadsCount;
    CyclicBarrier startBarrier;
    CyclicBarrier endBarrier;
    ExecutorService pool;
    AtomicBoolean stopped;
    TranspositionTable tt;
    NNUE network;

    public void reinit(int threadsCount) {
        this.init(threadsCount, this.tt, this.network);
    }

    public void reinit(NNUE network) {
        this.init(this.threadsCount, this.tt, network);
    }

    public void init(int threadsCount, TranspositionTable tt, NNUE network) {
        int i;
        if (this.threads != null) {
            this.shutdownAll();
        }
        this.threadsCount = threadsCount;
        this.startBarrier = new CyclicBarrier(this.threadsCount + 1);
        this.endBarrier = new CyclicBarrier(this.threadsCount + 1);
        this.threadData = new ArrayList<ThreadData>();
        this.threads = new ArrayList<AlphaBeta>();
        this.tt = tt;
        this.network = network;
        this.pool = Executors.newFixedThreadPool(this.threadsCount);
        this.stopped = new AtomicBoolean(false);
        ArrayList<ISearchListener> listeners = new ArrayList<ISearchListener>();
        this.startBarrier = new CyclicBarrier(this.threadsCount + 1);
        this.endBarrier = new CyclicBarrier(this.threadsCount + 1);
        SharedThreadData sharedData = new SharedThreadData(tt, this.startBarrier, this.endBarrier, network, this.stopped);
        ThreadData.MainThreadData mainThreadData = new ThreadData.MainThreadData(null, listeners, this.threads);
        this.threadData.add(new ThreadData(0, mainThreadData));
        for (i = 1; i < threadsCount; ++i) {
            this.threadData.add(new ThreadData(i));
        }
        listeners.add(new UCIListener());
        for (i = 0; i < this.threadsCount; ++i) {
            this.threads.add(new AlphaBeta(sharedData, this.threadData.get(i)));
            this.pool.execute(this.threads.get(i));
        }
    }

    public void initThreads(Board board, Limits limits) {
        for (AlphaBeta thread : this.threads) {
            thread.setBoard(board);
        }
        this.threads.get(0).updateTM(limits);
    }

    public void nextMove(Board board, Limits limits) {
        try {
            this.endBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            e.printStackTrace();
            return;
        }
        this.initThreads(board, limits);
        try {
            this.startBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public void clearData() {
        for (AlphaBeta thread : this.threads) {
            thread.reset();
        }
    }

    public long getNodes() {
        long nodes = 0L;
        for (AlphaBeta thread : this.threads) {
            nodes += thread.getNodesCount();
        }
        return nodes;
    }

    public AlphaBeta getMainThread() {
        return this.threads.get(0);
    }

    public void shutdownAll() {
        this.pool.shutdownNow();
    }

    public void stop() {
        this.stopped.set(true);
    }
}

