/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search;

import org.shawn.games.Serendipity.Search.Limits;
import org.shawn.games.Serendipity.UCI.IntegerOption;

public class TimeManager {
    private long startTime;
    private long hardLimitTimeStamp;
    private long softLimitTimeStamp;
    private static final IntegerOption moveOverHead = new IntegerOption(100, 0, 30000, "Move_Overhead");

    public void set(Limits limits) {
        this.set(limits.getTime(), limits.getIncrement(), limits.getMovesToGo());
    }

    public void set(long timeLeft, long increment, int movesToGo) {
        if (timeLeft < 0L) {
            timeLeft = 1000L;
        }
        timeLeft -= Math.min((long)moveOverHead.get(), timeLeft) / 2L;
        if (movesToGo != 0 && movesToGo != -1) {
            long hardLimit = timeLeft / (long)movesToGo + increment * 3L / 4L;
            long softLimit = hardLimit / 2L;
            this.startTime = System.nanoTime();
            this.hardLimitTimeStamp = this.startTime + 1000000L * hardLimit;
            this.softLimitTimeStamp = this.startTime + 1000000L * softLimit;
            return;
        }
        if (movesToGo == -1) {
            long softLimit;
            long hardLimit = softLimit = timeLeft;
            this.startTime = System.nanoTime();
            this.hardLimitTimeStamp = this.softLimitTimeStamp = this.startTime + 1000000L * timeLeft;
            return;
        }
        int baseTime = (int)((double)timeLeft * 0.054 + (double)increment * 0.85);
        int maxTime = (int)((double)timeLeft * 0.76);
        long hardLimit = Math.min(maxTime, (int)((double)baseTime * 3.04));
        long softLimit = Math.min(maxTime, (int)((double)baseTime * 0.76));
        this.startTime = System.nanoTime();
        this.hardLimitTimeStamp = this.startTime + 1000000L * hardLimit;
        this.softLimitTimeStamp = this.startTime + 1000000L * softLimit;
    }

    public boolean shouldStop() {
        return System.nanoTime() > this.hardLimitTimeStamp;
    }

    public boolean shouldStopIterativeDeepening() {
        return System.nanoTime() > this.softLimitTimeStamp;
    }

    public long timePassed() {
        return (System.nanoTime() - this.startTime) / 1000000L;
    }
}

