/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.Search;

import java.util.Arrays;
import org.shawn.games.Serendipity.Chess.move.Move;

public class TranspositionTable {
    public static final int NODETYPE_NONE = 0;
    public static final int NODETYPE_LOWERBOUND = 1;
    public static final int NODETYPE_UPPERBOUND = 2;
    public static final int NODETYPE_EXACT = 3;
    private static final int DEPTH_OFFSET = -4;
    public static final int DEPTH_NONE = -3;
    public static final int DEPTH_QS = -1;
    private int size = Integer.highestOneBit(size *= 104857);
    private int mask = this.size - 1;
    private short[] data1 = new short[this.size];
    private long[] data2 = new long[this.size];
    private static final int ENTRY_SIZE = 10;

    public TranspositionTable(int size) {
    }

    public Entry probe(long hash) {
        short fragment1 = this.data1[(int)(hash & (long)this.mask)];
        long fragment2 = this.data2[(int)(hash & (long)this.mask)];
        return new Entry(fragment1, fragment2);
    }

    public void write(Entry entry, long hash, int nodeType, int depth, int evaluation, Move move, int staticEval) {
        if (entry == null || !entry.hit() || nodeType == 3 || !entry.verifySignature(hash) || depth > entry.getDepth() - 4) {
            int writtenDepth = depth - -4;
            short fragment1 = (short)(nodeType | writtenDepth << 8);
            long fragment2 = hash >>> 48 | (long)(move == null ? 0 : move.asBytes() << 16) | ((long)staticEval & 0xFFFFL) << 32 | (long)evaluation << 48;
            this.data1[(int)hash & this.mask] = fragment1;
            this.data2[(int)hash & this.mask] = fragment2;
        }
    }

    public void clear() {
        Arrays.fill(this.data1, (short)0);
        Arrays.fill(this.data2, 0L);
    }

    public void resize(int size) {
        this.size = Integer.highestOneBit(size *= 104857);
        this.mask = this.size - 1;
        this.data1 = new short[this.size];
        this.data2 = new long[this.size];
    }

    public int hashfull() {
        int hashfull = 0;
        for (int i = 0; i < 1000; ++i) {
            if (this.data2[i] == 0L) continue;
            ++hashfull;
        }
        return hashfull;
    }

    public int hashfull_accurate() {
        int hashfull = 0;
        int minimum_hash = 104857;
        for (int i = 0; i < minimum_hash; ++i) {
            if (this.data2[i] == 0L) continue;
            ++hashfull;
        }
        return hashfull * 1000 / minimum_hash;
    }

    public int getSize() {
        return this.size * 10 / 0x100000;
    }

    public class Entry {
        private final int signature;
        private final int depth;
        private final int type;
        private final int evaluation;
        private final int staticEval;
        private final Move move;
        private final boolean hit;

        public Entry(short fragment1, long fragment2) {
            this(fragment1 & 3, (fragment1 >>> 8) + -4, (int)(fragment2 & 0xFFFFL), (int)(fragment2 & 0xFFFFFFFFFFFF0000L) >> 16, (short)((fragment2 & 0xFFFF00000000L) >>> 32), (int)(fragment2 >> 48), fragment1 != 0 && fragment2 != 0L);
        }

        public Entry(int nodeType, int depth, int signature, int move, int staticEval, int evaluation, boolean hit) {
            this.signature = signature;
            this.depth = depth;
            this.type = nodeType;
            this.move = move == 0 ? null : Move.fromBytes(move);
            this.evaluation = evaluation;
            this.staticEval = staticEval;
            this.hit = hit;
        }

        public long getSignature() {
            return this.signature;
        }

        public boolean verifySignature(long signature) {
            return (int)(signature >>> 48) == this.signature;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getNodeType() {
            return this.type;
        }

        public int getEvaluation() {
            return this.evaluation;
        }

        public int getStaticEval() {
            return this.staticEval;
        }

        public Move getMove() {
            return this.move;
        }

        public boolean hit() {
            return this.hit;
        }
    }
}

