/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.UCI;

import org.shawn.games.Serendipity.UCI.UCI;
import org.shawn.games.Serendipity.UCI.UCIOption;

public class IntegerOption
implements UCIOption {
    int value;
    final String name;
    final int defaultValue;
    final int lowerBound;
    final int upperBound;

    public IntegerOption(int value, int lowerBound, int upperBound, String name) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound must be less than or equal to upperBound");
        }
        this.value = this.defaultValue = value;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.name = name;
        UCI.addOption(name, this);
    }

    @Override
    public void set(String value) {
        int intValue = Integer.parseInt(value);
        this.value = intValue < this.lowerBound ? this.lowerBound : (intValue > this.upperBound ? this.upperBound : intValue);
    }

    public int get() {
        return this.value;
    }

    public String toString() {
        return "option name " + this.name + " type spin default " + this.defaultValue + " min " + this.lowerBound + " max " + this.upperBound;
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }
}

