/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.UCI;

import org.shawn.games.Serendipity.Chess.move.Move;
import org.shawn.games.Serendipity.Search.Listener.FinalReport;
import org.shawn.games.Serendipity.Search.Listener.ISearchListener;
import org.shawn.games.Serendipity.Search.Listener.SearchReport;
import org.shawn.games.Serendipity.UCI.WDLModel;

public class UCIListener
implements ISearchListener {
    @Override
    public void notify(SearchReport report) {
        StringBuffer pvString = new StringBuffer();
        for (Move move : report.pv) {
            if (move == null) break;
            pvString.append(" ").append(move);
        }
        if (Math.abs(report.score) < 32455) {
            int cp = WDLModel.normalizeEval(report.score, report.board);
            int[] wdl = WDLModel.calculateWDL(report.score, report.board);
            System.out.printf("info depth %d seldepth %d nodes %d nps %d hashfull %d score cp %d wdl %d %d %d time %d pv%s\n", report.depth, report.selDepth, report.nodes, report.nodes * 1000L / Math.max(1L, report.ms), report.hashfull, cp, wdl[0], wdl[1], wdl[2], report.ms, pvString);
        } else {
            int mateInPly = 32700 - Math.abs(report.score);
            int mateValue = mateInPly % 2 != 0 ? (mateInPly + 1) / 2 : -mateInPly / 2;
            int[] wdl = mateValue < 0 ? new int[]{0, 0, 1000} : new int[]{1000, 0, 0};
            System.out.printf("info depth %d seldepth %d nodes %d nps %d hashfull %d score mate %d wdl %d %d %d time %d pv %s\n", report.depth, report.selDepth, report.nodes, report.nodes * 1000L / Math.max(1L, report.ms), report.hashfull, mateValue, wdl[0], wdl[1], wdl[2], report.ms, pvString);
        }
    }

    @Override
    public void notify(FinalReport report) {
        System.out.println("bestmove " + String.valueOf(report.bestMove == null ? "(none)" : report.bestMove));
    }
}

