/*
 * Decompiled with CFR 0.152.
 */
package org.shawn.games.Serendipity.UCI;

import org.shawn.games.Serendipity.Chess.Board;
import org.shawn.games.Serendipity.Chess.Piece;

public class WDLModel {
    private static final double[] as = new double[]{-278.87388531, 792.92105507, -790.09312301, 502.8905465};
    private static final double[] bs = new double[]{-84.42811086, 271.38296047, -230.42218354, 118.07436762};
    private static final int NormalizeToPawnValue = 227;
    private static final int PAWN_VALUE = 1;
    private static final int KNIGHT_VALUE = 3;
    private static final int BISHOP_VALUE = 3;
    private static final int ROOK_VALUE = 5;
    private static final int QUEEN_VALUE = 9;

    private static int countMaterial(Board board) {
        return Long.bitCount(board.getBitboard(Piece.WHITE_PAWN)) * 1 + Long.bitCount(board.getBitboard(Piece.WHITE_KNIGHT)) * 3 + Long.bitCount(board.getBitboard(Piece.WHITE_BISHOP)) * 3 + Long.bitCount(board.getBitboard(Piece.WHITE_ROOK)) * 5 + Long.bitCount(board.getBitboard(Piece.WHITE_QUEEN)) * 9 + Long.bitCount(board.getBitboard(Piece.BLACK_PAWN)) * 1 + Long.bitCount(board.getBitboard(Piece.BLACK_KNIGHT)) * 3 + Long.bitCount(board.getBitboard(Piece.BLACK_BISHOP)) * 3 + Long.bitCount(board.getBitboard(Piece.BLACK_ROOK)) * 5 + Long.bitCount(board.getBitboard(Piece.BLACK_QUEEN)) * 9;
    }

    private static double[] calculateParameters(Board board) {
        int material = WDLModel.countMaterial(board);
        material = Math.max(material, 17);
        material = Math.min(material, 78);
        double m = (double)material / 58.0;
        double a = ((as[0] * m + as[1]) * m + as[2]) * m + as[3];
        double b = ((bs[0] * m + bs[1]) * m + bs[2]) * m + bs[3];
        return new double[]{a, b};
    }

    private static int calculateWinRate(int v, Board board) {
        double[] parameters = WDLModel.calculateParameters(board);
        return (int)(0.5 + 1000.0 / (1.0 + Math.exp((parameters[0] - (double)v) / parameters[1])));
    }

    public static int[] calculateWDL(int v, Board board) {
        int winRate = WDLModel.calculateWinRate(v, board);
        int lossRate = WDLModel.calculateWinRate(-v, board);
        int drawRate = 1000 - winRate - lossRate;
        return new int[]{winRate, drawRate, lossRate};
    }

    public static int normalizeEval(int v, Board board) {
        double a = WDLModel.calculateParameters(board)[0];
        return (int)Math.round((double)(100 * v) / a);
    }
}

