/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.controller.game;

import com.frommzay.chess.controller.game.GameController;
import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.util.PlayerColor;
import com.frommzay.chess.services.infrastructure.network.TcpClient;
import com.frommzay.chess.services.infrastructure.network.TcpHost;
import com.frommzay.chess.view.gui.ChessFrame;
import com.frommzay.chess.view.gui.MainMenuFrame;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class GameLauncher {
    public static void launch(GameState gameState, GameController controller) {
        new ChessFrame(gameState.getBoard(), controller);
    }

    public static void launchAsHost(GameState gameState, GameController controller, JDialog waitingDialog, MainMenuFrame menuFrame) {
        try {
            TcpHost host = new TcpHost(5000);
            controller.setLocalSide(PlayerColor.WHITE);
            controller.attachNetwork(host);
            if (waitingDialog != null) {
                waitingDialog.dispose();
            }
            SwingUtilities.invokeLater(() -> {
                new ChessFrame(gameState.getBoard(), controller);
                if (menuFrame != null) {
                    menuFrame.dispose();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean launchAsClient(GameState gameState, GameController controller, String ip) {
        try {
            TcpClient client = new TcpClient(ip, 5000);
            controller.setLocalSide(PlayerColor.BLACK);
            controller.attachNetwork(client);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        new ChessFrame(gameState.getBoard(), controller);
        return true;
    }
}

