/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.model.game;

import com.frommzay.chess.model.board.Board;
import com.frommzay.chess.model.board.BoardFactory;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.model.move.MoveGenerator;
import com.frommzay.chess.model.move.PromotionPiece;
import com.frommzay.chess.model.move.SpecialMoveHandler;
import com.frommzay.chess.model.pieces.Bishop;
import com.frommzay.chess.model.pieces.King;
import com.frommzay.chess.model.pieces.Knight;
import com.frommzay.chess.model.pieces.Piece;
import com.frommzay.chess.model.pieces.Queen;
import com.frommzay.chess.model.pieces.Rook;
import com.frommzay.chess.model.rules.GameOverType;
import com.frommzay.chess.model.util.PlayerColor;
import com.frommzay.chess.model.util.Position;
import java.util.List;

public class GameState {
    private final Board board;
    private PlayerColor turn;
    private final SpecialMoveHandler specialMoveHandler;

    public GameState() {
        this.board = BoardFactory.createDefaultBoard();
        this.turn = PlayerColor.WHITE;
        this.specialMoveHandler = new SpecialMoveHandler();
    }

    public GameState(GameState other) {
        this.turn = other.turn;
        this.board = new Board(other.board);
        this.specialMoveHandler = new SpecialMoveHandler(other.specialMoveHandler);
    }

    public GameState copy() {
        return new GameState(this);
    }

    public PlayerColor getTurn() {
        return this.turn;
    }

    public Board getBoard() {
        return this.board;
    }

    public SpecialMoveHandler getSpecialMoveHandler() {
        return this.specialMoveHandler;
    }

    public boolean isTurn(PlayerColor color) {
        return this.getTurn() == color;
    }

    public void changeTurn() {
        this.turn = this.turn == PlayerColor.WHITE ? PlayerColor.BLACK : PlayerColor.WHITE;
    }

    public Piece getPieceAt(Position pos) {
        return this.board.getPieceAt(pos);
    }

    public Piece getPieceAt(int rank, int file) {
        return this.board.getPieceAt(rank, file);
    }

    public void applyMove(Move m) {
        this.specialMoveHandler.updateHasMovedFlags(this, m);
        this.specialMoveHandler.updateEnPassantTarget(this, m);
        Position from = m.getFromPos();
        Position to = m.getToPos();
        Piece mover = this.getPieceAt(from);
        switch (m.getMoveType()) {
            case EN_PASSANT: {
                int toRank = m.getToPos().getRank();
                int toFile = m.getToPos().getFile();
                switch (this.getPieceColorAt(m)) {
                    case BLACK: {
                        this.setPieceAt(toRank - 1, toFile, null);
                        break;
                    }
                    case WHITE: {
                        this.setPieceAt(toRank + 1, toFile, null);
                    }
                }
                break;
            }
            case CASTLE: {
                this.specialMoveHandler.moveRookDuringCastle(this, m);
                break;
            }
            case PROMOTION: {
                if (m.getPromotion() == null) break;
                PlayerColor color = this.board.getPieceAt(m.getFromPos()).getColor();
                mover = switch (m.getPromotion()) {
                    default -> throw new MatchException(null, null);
                    case PromotionPiece.QUEEN -> new Queen(color, to);
                    case PromotionPiece.ROOK -> new Rook(color, to);
                    case PromotionPiece.BISHOP -> new Bishop(color, to);
                    case PromotionPiece.KNIGHT -> new Knight(color, to);
                };
                break;
            }
        }
        this.setPieceAt(from, null);
        this.setPieceAt(m.getToPos(), mover);
        this.changeTurn();
    }

    public Class<? extends Piece> getPieceTypeAt(Move m) {
        return this.getPieceAt(m.getFromPos()).getClass();
    }

    public PlayerColor getPieceColorAt(Move m) {
        return this.getPieceAt(m.getFromPos()).getColor();
    }

    public boolean isGameOver() {
        List<Piece> colorPieces = this.getPiecesOfColor(this.turn);
        for (Piece piece : colorPieces) {
            if (MoveGenerator.generateLegalMoves(this, piece.getPos()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public GameOverType getGameOverType() {
        if (this.getKingOfColor(this.turn).isInCheck(this)) {
            return GameOverType.CHECKMATE;
        }
        return GameOverType.DRAW;
    }

    public List<Piece> getPiecesOfColor(PlayerColor color) {
        return this.board.getPiecesOfColor(color);
    }

    public King getKingOfColor(PlayerColor color) {
        List<Piece> pieces = this.board.getPiecesOfColor(color);
        for (Piece piece : pieces) {
            if (!(piece instanceof King)) continue;
            return (King)piece;
        }
        return null;
    }

    public PlayerColor getWinner() {
        if (this.getGameOverType() == GameOverType.CHECKMATE) {
            return this.turn.getOpposite();
        }
        return null;
    }

    public boolean isInCheck() {
        return this.getKingOfColor(this.turn).isInCheck(this);
    }

    public void setPieceAt(Position pos, Piece piece) {
        this.getBoard().setPieceAt(pos, piece);
        if (piece != null) {
            piece.updateCoords(pos);
        }
    }

    public void setPieceAt(int rank, int file, Piece piece) {
        this.getBoard().setPieceAt(rank, file, piece);
        if (piece != null) {
            piece.updateCoords(rank, file);
        }
    }

    public PlayerColor getPieceColorAt(Position from) {
        return this.getPieceAt(from).getColor();
    }

    public GameState snapshot() {
        return new GameState(this);
    }

    public void restoreFrom(GameState snap) {
        this.turn = snap.turn;
        for (int r = 0; r < 8; ++r) {
            for (int f = 0; f < 8; ++f) {
                Piece p = snap.board.getPieceAt(r, f);
                this.setPieceAt(r, f, p == null ? null : p.copy());
            }
        }
        this.specialMoveHandler.copyFrom(snap.specialMoveHandler);
    }
}

