/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.model.move;

import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.model.move.MoveType;
import com.frommzay.chess.model.pieces.King;
import com.frommzay.chess.model.pieces.Pawn;
import com.frommzay.chess.model.pieces.Piece;
import com.frommzay.chess.model.pieces.Rook;
import com.frommzay.chess.model.util.PlayerColor;
import com.frommzay.chess.model.util.Position;
import java.util.List;

public class SpecialMoveHandler {
    private boolean whiteKingMoved;
    private boolean blackKingMoved;
    private boolean whiteKingsideRookMoved;
    private boolean whiteQueensideRookMoved;
    private boolean blackKingsideRookMoved;
    private boolean blackQueensideRookMoved;
    private Position enPassantTarget;

    public SpecialMoveHandler() {
        this.enPassantTarget = null;
        this.whiteKingMoved = false;
        this.blackKingMoved = false;
        this.whiteKingsideRookMoved = false;
        this.whiteQueensideRookMoved = false;
        this.blackKingsideRookMoved = false;
        this.blackQueensideRookMoved = false;
    }

    public Position getEnPassantTarget() {
        return this.enPassantTarget;
    }

    public void addEnPassantMoves(GameState s, Position pos, List<Move> pseudoLegalMoves) {
        if (this.enPassantTarget == null) {
            return;
        }
        Move epMove = new Move(pos, this.enPassantTarget, MoveType.EN_PASSANT);
        if (this.isEnPassantValid(s, epMove)) {
            pseudoLegalMoves.add(epMove);
        }
    }

    public boolean isEnPassantValid(GameState s, Move m) {
        if (this.enPassantTarget == null) {
            return false;
        }
        Position from = m.getFromPos();
        Position to = m.getToPos();
        Piece mover = s.getPieceAt(from);
        if (!(mover instanceof Pawn)) {
            return false;
        }
        if (!to.equals(this.enPassantTarget)) {
            return false;
        }
        int dir = this.getDir(mover.getColor());
        if (to.getRank() - from.getRank() != dir) {
            return false;
        }
        if (Math.abs(to.getFile() - from.getFile()) != 1) {
            return false;
        }
        if (s.getPieceAt(to) != null) {
            return false;
        }
        Position capturedPos = new Position(from.getRank(), to.getFile());
        Piece captured = s.getPieceAt(capturedPos);
        if (!(captured instanceof Pawn)) {
            return false;
        }
        return captured.getColor() != mover.getColor();
    }

    private int getDir(PlayerColor color) {
        return color == PlayerColor.WHITE ? -1 : 1;
    }

    public void updateEnPassantTarget(GameState s, Move m) {
        this.enPassantTarget = null;
        Position from = m.getFromPos();
        Position to = m.getToPos();
        Piece mover = s.getPieceAt(from);
        if (!(mover instanceof Pawn)) {
            return;
        }
        int fromRank = from.getRank();
        int toRank = to.getRank();
        int file = from.getFile();
        if (Math.abs(toRank - fromRank) == 2 && fromRank == SpecialMoveHandler.pawnStartRank(mover.getColor())) {
            int midRank = (fromRank + toRank) / 2;
            this.enPassantTarget = new Position(midRank, file);
        }
    }

    private static int pawnStartRank(PlayerColor color) {
        return color == PlayerColor.WHITE ? 6 : 1;
    }

    private static int kingRookStartRank(PlayerColor color) {
        return color == PlayerColor.WHITE ? 7 : 0;
    }

    public void addCastlingMoves(GameState s, Position from, List<Move> pseudoLegalMoves) {
        Piece p = s.getPieceAt(from);
        if (!(p instanceof King)) {
            return;
        }
        if (from.getFile() != 4) {
            return;
        }
        if (from.getRank() != SpecialMoveHandler.kingRookStartRank(p.getColor())) {
            return;
        }
        Move queenside = new Move(from, new Position(from.getRank(), 2), MoveType.CASTLE);
        Move kingside = new Move(from, new Position(from.getRank(), 6), MoveType.CASTLE);
        for (Move m : new Move[]{queenside, kingside}) {
            if (!this.isCastlingValid(s, m)) continue;
            pseudoLegalMoves.add(m);
        }
    }

    public boolean isCastlingValid(GameState s, Move m) {
        boolean queenSide;
        Position from = m.getFromPos();
        Position to = m.getToPos();
        Piece mover = s.getPieceAt(from);
        if (!(mover instanceof King)) {
            return false;
        }
        PlayerColor us = mover.getColor();
        PlayerColor them = us.getOpposite();
        if (from.getRank() != SpecialMoveHandler.kingRookStartRank(us)) {
            return false;
        }
        if (from.getFile() != 4) {
            return false;
        }
        int toFile = to.getFile();
        if (to.getRank() != from.getRank()) {
            return false;
        }
        boolean kingSide = toFile == 6;
        boolean bl = queenSide = toFile == 2;
        if (!kingSide && !queenSide) {
            return false;
        }
        if (s.getPieceAt(to) != null) {
            return false;
        }
        if (us == PlayerColor.WHITE) {
            if (this.whiteKingMoved) {
                return false;
            }
            if (kingSide && this.whiteKingsideRookMoved) {
                return false;
            }
            if (queenSide && this.whiteQueensideRookMoved) {
                return false;
            }
        } else {
            if (this.blackKingMoved) {
                return false;
            }
            if (kingSide && this.blackKingsideRookMoved) {
                return false;
            }
            if (queenSide && this.blackQueensideRookMoved) {
                return false;
            }
        }
        int rookFile = kingSide ? 7 : 0;
        Position rookPos = new Position(from.getRank(), rookFile);
        Piece rook = s.getPieceAt(rookPos);
        if (!(rook instanceof Rook) || rook.getColor() != us) {
            return false;
        }
        int stepKR = rookFile > from.getFile() ? 1 : -1;
        for (int f = from.getFile() + stepKR; f != rookFile; f += stepKR) {
            if (s.getPieceAt(new Position(from.getRank(), f)) == null) continue;
            return false;
        }
        if (s.getKingOfColor(us).isInCheck(s)) {
            return false;
        }
        int stepK = toFile > from.getFile() ? 1 : -1;
        for (int f = from.getFile() + stepK; f != toFile + stepK; f += stepK) {
            Position sq = new Position(from.getRank(), f);
            if (!this.isSquareAttacked(s, sq, them)) continue;
            return false;
        }
        return true;
    }

    private boolean isSquareAttacked(GameState s, Position sq, PlayerColor them) {
        GameState probe = s.copy();
        King king = probe.getKingOfColor(them.getOpposite());
        Move m = new Move(king.getPos(), sq, MoveType.NORMAL);
        probe.applyMove(m);
        probe.changeTurn();
        return king.isInCheck(probe);
    }

    public void printHasMovedFlags() {
        System.out.println("whiteKingMoved=" + this.whiteKingMoved + " blackKingMoved=" + this.blackKingMoved + " whiteKingsideRookMoved=" + this.whiteKingsideRookMoved + " whiteQueensideRookMoved=" + this.whiteQueensideRookMoved + " blackKingsideRookMoved=" + this.blackKingsideRookMoved + " blackQueensideRookMoved=" + this.blackQueensideRookMoved);
    }

    public void updateHasMovedFlags(GameState s, Move m) {
        boolean isWhite;
        Position from = m.getFromPos();
        Piece mover = s.getPieceAt(from);
        PlayerColor us = mover.getColor();
        boolean bl = isWhite = us == PlayerColor.WHITE;
        if (mover instanceof King) {
            if (isWhite) {
                this.whiteKingMoved = true;
            } else {
                this.blackKingMoved = true;
            }
        }
        if (mover instanceof Rook && from.getRank() == SpecialMoveHandler.kingRookStartRank(mover.getColor())) {
            if (from.getFile() == 0) {
                if (isWhite) {
                    this.whiteQueensideRookMoved = true;
                } else {
                    this.blackQueensideRookMoved = true;
                }
            } else if (from.getFile() == 7) {
                if (isWhite) {
                    this.whiteKingsideRookMoved = true;
                } else {
                    this.blackKingsideRookMoved = true;
                }
            }
        }
    }

    public void moveRookDuringCastle(GameState state, Move m) {
        int r = m.getFromPos().getRank();
        if (m.getToPos().getFile() == 6) {
            this.movePieceFromTo(state, r, 7, r, 5);
        } else if (m.getToPos().getFile() == 2) {
            this.movePieceFromTo(state, r, 0, r, 3);
        }
    }

    public void movePieceFromTo(GameState state, int from_rank, int from_file, int to_rank, int to_file) {
        state.setPieceAt(to_rank, to_file, state.getPieceAt(from_rank, from_file));
        state.setPieceAt(from_rank, from_file, null);
    }

    public void movePieceFromTo(GameState state, Position from, Position to) {
        state.setPieceAt(to, state.getPieceAt(from));
        state.setPieceAt(from, null);
    }

    public SpecialMoveHandler(SpecialMoveHandler other) {
        this.enPassantTarget = other.enPassantTarget;
        this.whiteKingMoved = other.whiteKingMoved;
        this.blackKingMoved = other.blackKingMoved;
        this.whiteKingsideRookMoved = other.whiteKingsideRookMoved;
        this.whiteQueensideRookMoved = other.whiteQueensideRookMoved;
        this.blackKingsideRookMoved = other.blackKingsideRookMoved;
        this.blackQueensideRookMoved = other.blackQueensideRookMoved;
    }

    public SpecialMoveHandler copy() {
        return new SpecialMoveHandler(this);
    }

    public void copyFrom(SpecialMoveHandler other) {
        this.enPassantTarget = other.enPassantTarget == null ? null : new Position(other.enPassantTarget);
        this.whiteKingMoved = other.whiteKingMoved;
        this.blackKingMoved = other.blackKingMoved;
        this.whiteKingsideRookMoved = other.whiteKingsideRookMoved;
        this.whiteQueensideRookMoved = other.whiteQueensideRookMoved;
        this.blackKingsideRookMoved = other.blackKingsideRookMoved;
        this.blackQueensideRookMoved = other.blackQueensideRookMoved;
    }
}

