/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.model.pieces;

import com.frommzay.chess.model.board.Board;
import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.model.move.MoveType;
import com.frommzay.chess.model.pieces.Piece;
import com.frommzay.chess.model.util.PlayerColor;
import com.frommzay.chess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public class Knight
extends Piece {
    public Knight(PlayerColor color, Position pos) {
        super(color, pos);
    }

    @Override
    public List<Move> generatePseudoLegalMoves(GameState gameState, Position from) {
        ArrayList<Move> moves = new ArrayList<Move>();
        Board board = gameState.getBoard();
        this.addMoves(board, moves, from.getRank(), from.getFile());
        return moves;
    }

    private void addOneMove(Board board, List<Move> moves, int r, int f, int dirR, int dirF) {
        int rank = r + dirR;
        int file = f + dirF;
        if (!board.isInside(rank, file).booleanValue()) {
            return;
        }
        if (!board.isEmpty(rank, file) && !this.getColor().isOpposite(board.getPieceAt(rank, file).getColor())) {
            return;
        }
        MoveType moveType = board.isEmpty(rank, file) ? MoveType.NORMAL : MoveType.CAPTURE;
        moves.add(new Move(new Position(r, f), new Position(rank, file), moveType));
    }

    private void addMoves(Board board, List<Move> moves, int r, int f) {
        int[] deltas;
        for (int dr : deltas = new int[]{2, 1, -1, -2}) {
            for (int df : deltas) {
                if (Math.abs(dr) == Math.abs(df)) continue;
                this.addOneMove(board, moves, r, f, dr, df);
            }
        }
    }

    @Override
    public char getSymbol() {
        return 'N';
    }

    @Override
    public String getName() {
        return "knight";
    }

    protected Knight(Knight other) {
        super(other);
    }

    @Override
    public Knight copy() {
        return new Knight(this);
    }
}

