/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.model.pieces;

import com.frommzay.chess.model.board.Board;
import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.model.move.MoveType;
import com.frommzay.chess.model.util.PlayerColor;
import com.frommzay.chess.model.util.Position;
import java.util.List;

public abstract class Piece {
    private final PlayerColor color;
    private Position pos;

    protected Piece(PlayerColor color, Position pos) {
        this.color = color;
        this.pos = pos;
    }

    protected Piece(PlayerColor color, int rank, int file) {
        this.color = color;
        this.pos = new Position(rank, file);
    }

    public PlayerColor getColor() {
        return this.color;
    }

    public Position getPos() {
        return this.pos;
    }

    public abstract List<Move> generatePseudoLegalMoves(GameState var1, Position var2);

    public Boolean isTurn(GameState gameState) {
        return gameState.getTurn() == this.getColor();
    }

    protected Piece(Piece other) {
        this.color = other.color;
        this.pos = new Position(other.pos.getRank(), other.pos.getFile());
    }

    public abstract Piece copy();

    public abstract char getSymbol();

    public abstract String getName();

    public String getPngName() {
        return this.getColor().toString().toLowerCase() + "_" + this.getSymbol();
    }

    public void generateDefaultAllMoves(Board board, Position fromPos, List<Move> moves) {
        for (int r = 0; r < 8; ++r) {
            for (int f = 0; f < 8; ++f) {
                if (!board.isInside(r, f).booleanValue() || !board.isEmpty(r, f) && this.getColor() == board.getPieceAt(r, f).getColor()) continue;
                moves.add(new Move(new Position(r, f), new Position(r, f), MoveType.NORMAL));
            }
        }
    }

    public void updateCoords(Position newPos) {
        this.pos = newPos;
    }

    public void updateCoords(int rank, int file) {
        this.pos = new Position(rank, file);
    }
}

