/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.services.application.history;

import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.services.application.history.MoveHistoryService;
import java.util.ArrayDeque;
import java.util.Deque;

public final class MoveHistoryInMemory
implements MoveHistoryService {
    private final Deque<Entry> undo = new ArrayDeque<Entry>();
    private final Deque<Entry> redo = new ArrayDeque<Entry>();

    @Override
    public void record(GameState gs, Move m, GameState snap) {
        this.undo.push(new Entry(m, snap));
        this.redo.clear();
    }

    @Override
    public boolean canUndo() {
        return !this.undo.isEmpty();
    }

    @Override
    public void undo(GameState gs) {
        Entry e = this.undo.pop();
        gs.restoreFrom(e.snapshotBefore);
        this.redo.push(e);
    }

    @Override
    public boolean canRedo() {
        return !this.redo.isEmpty();
    }

    @Override
    public void redo(GameState gs) {
        Entry e = this.redo.pop();
        gs.applyMove(e.move);
        this.undo.push(e);
    }

    @Override
    public Move peekRedoMove() {
        return this.redo.isEmpty() ? null : this.redo.peek().move;
    }

    private static final class Entry {
        final Move move;
        final GameState snapshotBefore;

        Entry(Move m, GameState s) {
            this.move = m;
            this.snapshotBefore = s;
        }
    }
}

