/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.services.application.notation;

import com.frommzay.chess.model.board.Board;
import com.frommzay.chess.model.game.GameState;
import com.frommzay.chess.model.move.Move;
import com.frommzay.chess.model.move.MoveGenerator;
import com.frommzay.chess.model.move.MoveType;
import com.frommzay.chess.model.move.PromotionPiece;
import com.frommzay.chess.model.pieces.King;
import com.frommzay.chess.model.pieces.Piece;
import com.frommzay.chess.model.rules.GameOverType;
import com.frommzay.chess.model.util.Position;
import java.util.ArrayList;
import java.util.List;

public final class NotationSAN {
    private NotationSAN() {
    }

    public static String toSAN(GameState before, Move m) {
        return NotationSAN.toSAN(before, m, false);
    }

    public static String toSAN(GameState before, Move m, boolean includeEpSuffix) {
        Board board = before.getBoard();
        Position from = m.getFromPos();
        Position to = m.getToPos();
        Piece mover = board.getPieceAt(from);
        if (mover == null) {
            throw new IllegalArgumentException("No piece at move.from");
        }
        if (mover instanceof King && Math.abs(to.getFile() - from.getFile()) == 2) {
            String san = to.getFile() > from.getFile() ? "O-O" : "O-O-O";
            return NotationSAN.appendCheckSymbols(NotationSAN.after(before, m), san);
        }
        boolean isEnPassant = m.getMoveType() == MoveType.EN_PASSANT;
        boolean isCapture = isEnPassant || board.getPieceAt(to) != null;
        char pieceChar = Character.toUpperCase(mover.getSymbol());
        boolean isPawn = pieceChar == 'P' || mover.getName().equalsIgnoreCase("pawn");
        StringBuilder san = new StringBuilder();
        if (!isPawn) {
            san.append(NotationSAN.pieceLetterForSAN(pieceChar));
            san.append(NotationSAN.disambiguation(before, mover, from, to));
        } else if (isCapture) {
            san.append(NotationSAN.fileChar(from.getFile()));
        }
        if (isCapture) {
            san.append('x');
        }
        san.append(NotationSAN.square(to));
        if (m.getMoveType() == MoveType.PROMOTION) {
            PromotionPiece pp = m.getPromotion();
            if (pp == null) {
                throw new IllegalArgumentException("Promotion choice missing in move");
            }
            san.append('=').append(NotationSAN.promotionLetter(pp));
        }
        if (includeEpSuffix && isEnPassant) {
            san.append(" e.p.");
        }
        return NotationSAN.appendCheckSymbols(NotationSAN.after(before, m), san.toString());
    }

    private static GameState after(GameState before, Move m) {
        GameState probe = before.copy();
        probe.applyMove(m);
        return probe;
    }

    private static String appendCheckSymbols(GameState after, String base) {
        if (after.isGameOver()) {
            if (after.getGameOverType() == GameOverType.CHECKMATE) {
                return base + "#";
            }
            return base;
        }
        if (after.isInCheck()) {
            return base + "+";
        }
        return base;
    }

    private static String disambiguation(GameState before, Piece mover, Position from, Position to) {
        ArrayList<Position> conflicts = new ArrayList<Position>();
        List<Piece> sameColor = before.getBoard().getPiecesOfColor(mover.getColor());
        block0: for (Piece p : sameColor) {
            if (p == mover || !p.getClass().equals(mover.getClass())) continue;
            List<Move> moves = MoveGenerator.generateLegalMoves(before, p.getPos());
            for (Move cand : moves) {
                if (!cand.getToPos().equals(to)) continue;
                conflicts.add(p.getPos());
                continue block0;
            }
        }
        if (conflicts.isEmpty()) {
            return "";
        }
        boolean fileUnique = true;
        boolean rankUnique = true;
        for (Position other : conflicts) {
            if (other.getFile() == from.getFile()) {
                fileUnique = false;
            }
            if (other.getRank() != from.getRank()) continue;
            rankUnique = false;
        }
        if (fileUnique) {
            return String.valueOf(NotationSAN.fileChar(from.getFile()));
        }
        if (rankUnique) {
            return String.valueOf(NotationSAN.rankDigit(from.getRank()));
        }
        return "" + NotationSAN.fileChar(from.getFile()) + NotationSAN.rankDigit(from.getRank());
    }

    private static char pieceLetterForSAN(char symbol) {
        char up = Character.toUpperCase(symbol);
        return up == 'P' ? (char)'\u0000' : up;
    }

    private static String square(Position p) {
        return "" + NotationSAN.fileChar(p.getFile()) + NotationSAN.rankDigit(p.getRank());
    }

    private static char fileChar(int file) {
        return (char)(97 + file);
    }

    private static char rankDigit(int rank) {
        return (char)(48 + (8 - rank));
    }

    private static char promotionLetter(PromotionPiece pp) {
        return switch (pp) {
            default -> throw new MatchException(null, null);
            case PromotionPiece.QUEEN -> 'Q';
            case PromotionPiece.ROOK -> 'R';
            case PromotionPiece.BISHOP -> 'B';
            case PromotionPiece.KNIGHT -> 'N';
        };
    }
}

