/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.services.infrastructure.network;

import com.frommzay.chess.services.infrastructure.network.MoveMessage;

public final class MoveCodec {
    private MoveCodec() {
    }

    public static String encode(MoveMessage m) {
        return "MOVE|" + m.fromRank() + "," + m.fromFile() + "|" + m.toRank() + "," + m.toFile() + "|" + (m.type() == null ? "NORMAL" : m.type());
    }

    public static MoveMessage tryDecode(String line) {
        try {
            if (line == null || !line.startsWith("MOVE|")) {
                return null;
            }
            String[] parts = line.split("\\|");
            String[] a = parts[1].split(",");
            String[] b = parts[2].split(",");
            String type = parts.length > 3 ? parts[3] : "NORMAL";
            return new MoveMessage(Integer.parseInt(a[0]), Integer.parseInt(a[1]), Integer.parseInt(b[0]), Integer.parseInt(b[1]), type);
        }
        catch (Exception e) {
            return null;
        }
    }
}

