/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.services.infrastructure.network;

import com.frommzay.chess.services.infrastructure.network.NetworkTransport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class TcpClient
implements NetworkTransport {
    private final String host;
    private final int port;
    private volatile NetworkTransport.Listener listener;
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private Thread reader;

    public TcpClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void setListener(NetworkTransport.Listener l) {
        this.listener = l;
    }

    @Override
    public void start() {
        this.reader = new Thread(() -> {
            block3: {
                try {
                    String line;
                    this.socket = new Socket(this.host, this.port);
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    this.out = new PrintWriter(this.socket.getOutputStream(), true);
                    this.out.println("HELLO");
                    while ((line = this.in.readLine()) != null) {
                        NetworkTransport.Listener L = this.listener;
                        if (L == null) continue;
                        L.onMessage(line);
                    }
                }
                catch (Exception e) {
                    NetworkTransport.Listener L = this.listener;
                    if (L == null) break block3;
                    L.onError(e);
                }
            }
        }, "TcpClient-Reader");
        this.reader.setDaemon(true);
        this.reader.start();
    }

    @Override
    public void send(String line) {
        if (this.out != null) {
            this.out.println(line);
        }
    }

    @Override
    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.reader != null) {
            this.reader.interrupt();
        }
    }
}

