/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.view.gui;

import com.frommzay.chess.controller.input.MouseInputHandler;
import com.frommzay.chess.model.board.Board;
import com.frommzay.chess.model.util.Position;
import com.frommzay.chess.view.gui.swing.SquareButton;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class BoardPanel
extends JPanel {
    private static final long serialVersionUID = -5701354526177242530L;
    private static final int BOARD_SIZE = 8;
    private final SquareButton[][] squares = new SquareButton[8][8];
    private final MouseInputHandler mouseInputHandler;
    private final Color darkSqColor = new Color(32, 108, 125);
    private final Color lightSqColor = new Color(160, 221, 235);

    public BoardPanel(Board board, MouseInputHandler mouseInputHandler) {
        this.mouseInputHandler = mouseInputHandler;
        this.setLayout(new GridLayout(8, 8));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.initializeBoard(board);
    }

    private void initializeBoard(Board board) {
        this.removeAll();
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                Position position = new Position(row, col);
                boolean light = (row + col) % 2 == 0;
                Color base = light ? this.lightSqColor : this.darkSqColor;
                SquareButton button = new SquareButton(position, base);
                button.setBorderPainted(false);
                button.setPiece(board.getPieceAt(position));
                button.addActionListener(this.mouseInputHandler);
                this.squares[row][col] = button;
                button.setPreferredSize(new Dimension(70, 70));
                this.add(button);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void updateBoard(Board board) {
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                this.squares[row][col].setPiece(board.getPieceAt(new Position(row, col)));
            }
        }
        this.repaint();
    }

    public SquareButton getSquareButton(Position position) {
        return this.squares[position.getRank()][position.getFile()];
    }
}

