/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.view.gui;

import com.frommzay.chess.view.gui.MainMenuFrame;
import com.frommzay.chess.view.gui.ResourceLoader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MainMenuPanel
extends JPanel {
    private static final long serialVersionUID = 3788552984549957863L;
    private final Image backgroundImage = ResourceLoader.MAIN_MENU_BACKGROUND;
    private final int uiHeight;
    private final int uiWidth;

    public MainMenuPanel(MainMenuFrame owner, int targetHeight) {
        int imgW = 0;
        int imgH = 0;
        if (this.backgroundImage != null) {
            ImageIcon ii = new ImageIcon(this.backgroundImage);
            imgW = ii.getIconWidth();
            imgH = ii.getIconHeight();
        }
        if (imgW <= 0 || imgH <= 0) {
            imgW = 1920;
            imgH = 1080;
        }
        this.uiHeight = targetHeight;
        this.uiWidth = (int)Math.round((double)targetHeight * ((double)imgW / (double)imgH));
        Dimension d = new Dimension(this.uiWidth, this.uiHeight);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        JButton local = this.createMenuButton("Local Game");
        JButton vsAI = this.createMenuButton("Play vs Computer");
        JButton load = this.createMenuButton("Load Saved Game");
        JButton host = this.createMenuButton("Host Multiplayer");
        JButton join = this.createMenuButton("Join Multiplayer");
        int vertSeparation = 0;
        this.add(this.center(local));
        this.add(Box.createRigidArea(new Dimension(0, vertSeparation)));
        this.add(this.center(vsAI));
        this.add(Box.createRigidArea(new Dimension(0, vertSeparation)));
        this.add(this.center(load));
        this.add(Box.createRigidArea(new Dimension(0, vertSeparation)));
        this.add(this.center(host));
        this.add(Box.createRigidArea(new Dimension(0, vertSeparation)));
        this.add(this.center(join));
        this.add(Box.createVerticalGlue());
        local.addActionListener(e -> owner.startLocalGame());
        vsAI.addActionListener(e -> owner.startVsComputer());
        load.addActionListener(e -> owner.loadLocalGame());
        host.addActionListener(e -> owner.startHostGame());
        join.addActionListener(e -> {
            String ip = JOptionPane.showInputDialog(owner, (Object)"Host IP:");
            if (ip != null && !ip.isBlank()) {
                owner.startClientGame(ip.trim());
            }
        });
    }

    private JButton createMenuButton(String text) {
        JButton button = new JButton(text){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                float alpha = 0.35f;
                ButtonModel m = this.getModel();
                if (m.isRollover()) {
                    alpha = 0.5f;
                }
                if (m.isPressed()) {
                    alpha = 0.65f;
                }
                g2.setComposite(AlphaComposite.SrcOver.derive(alpha));
                g2.setColor(new Color(255, 255, 255));
                int arc = 14;
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
                g2.dispose();
                super.paintComponent(g);
            }
        };
        button.setAlignmentX(0.5f);
        button.setPreferredSize(new Dimension(220, 45));
        button.setMaximumSize(new Dimension(220, 45));
        button.setFont(new Font("SansSerif", 1, 16));
        button.setForeground(Color.BLACK);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(true);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        return button;
    }

    private Component center(JButton button) {
        JPanel wrapper = new JPanel();
        wrapper.setOpaque(false);
        wrapper.setLayout(new FlowLayout(1, 0, 5));
        wrapper.add(button);
        return wrapper;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, this.uiWidth, this.uiHeight, this);
        }
    }
}

