/*
 * Decompiled with CFR 0.152.
 */
package com.frommzay.chess.view.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MoveListPanel
extends JPanel {
    private static final long serialVersionUID = 4252547406430916548L;
    private final JTextArea moveListArea;
    private final Color bgColor = new Color(250, 250, 250);

    public MoveListPanel() {
        this.setLayout(new BorderLayout());
        this.moveListArea = new JTextArea();
        this.moveListArea.setEditable(false);
        this.moveListArea.setBackground(this.bgColor);
        this.moveListArea.setMargin(new Insets(6, 8, 6, 8));
        this.moveListArea.setFont(new Font("Monospaced", 0, 13));
        JScrollPane scrollPane = new JScrollPane(this.moveListArea);
        this.add((Component)scrollPane, "Center");
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setPreferredSize(new Dimension(300, 400));
    }

    public void appendMove(String move) {
        this.moveListArea.append(move + "\n");
        System.out.println(move);
    }

    public void removeMove(List<String> moves, String move) {
        this.clearMoves();
        for (String moveString : moves) {
            if (moveString.equals(move)) continue;
            this.appendMove(moveString);
        }
    }

    public void clearMoves() {
        this.moveListArea.setText("");
    }
}

